/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.shared.AbstractHomeFeature;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPathHomeFeature
extends AbstractHomeFeature {
    private static final Logger log = LogManager.getLogger(DefaultPathHomeFeature.class);
    private final Host host;

    public DefaultPathHomeFeature(Host host) {
        this.host = host;
    }

    @Override
    public Path find() throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)this.host.getDefaultPath())) {
            return PathNormalizer.compose(ROOT, this.host.getDefaultPath());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("No default path set for bookmark %s", this.host));
        }
        return null;
    }
}

