/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.shared.ListFilteringFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultFindFeature
extends ListFilteringFeature
implements Find {
    private static final Logger log = LogManager.getLogger(DefaultFindFeature.class);

    public DefaultFindFeature(Session<?> session) {
        super(session);
    }

    @Override
    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            Path found = this.search(file, listener);
            return found != null;
        }
        catch (NotfoundException e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Parent directory for file %s not found", file));
            }
            return false;
        }
    }
}

