/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(DefaultCopyFeature.class);
    private Session<?> from;
    private Session<?> to;

    public DefaultCopyFeature(Session<?> from) {
        this.from = from;
        this.to = from;
    }

    @Override
    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        InputStream in = this.from.getFeature(Read.class).read(source, new TransferStatus(status), callback);
        Write writer = this.to.getFeature(MultipartWrite.class);
        if (null == writer) {
            writer = this.to.getFeature(Write.class);
        }
        StatusOutputStream out = writer.write(target, status, callback);
        new StreamCopier(status, status).withListener(listener).transfer(in, (OutputStream)((Object)out));
        if (!PathAttributes.EMPTY.equals(status.getResponse())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Received reply %s for creating file %s", status.getResponse(), target));
            }
            return new Path(target).withAttributes(status.getResponse());
        }
        log.warn(String.format("Missing status from writer %s", writer));
        return target;
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        switch (this.from.getHost().getProtocol().getType()) {
            case ftp: 
            case irods: {
                return !Objects.equals(this.from, this.to);
            }
        }
        return true;
    }

    @Override
    public DefaultCopyFeature withTarget(Session<?> session) {
        this.to = session;
        return this;
    }
}

