/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.idna.PunycodeConverter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class CustomSchemeUrlProvider
implements UrlProvider {
    private final Host host;

    public CustomSchemeUrlProvider(Host host) {
        this.host = host;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        for (String scheme : this.host.getProtocol().getSchemes()) {
            if (!Arrays.stream(Scheme.values()).noneMatch(s -> s.name().equals(scheme))) continue;
            list.add(new DescriptiveUrl(URI.create(String.format("%s://%s%s", scheme, new PunycodeConverter().convert(this.host.getHostname()), PathNormalizer.normalize(file.getAbsolute()))), DescriptiveUrl.Type.provider, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), StringUtils.capitalize((String)scheme))));
        }
        return list;
    }
}

