/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BufferInputStream;
import ch.cyberduck.core.io.BufferOutputStream;
import ch.cyberduck.core.io.FileBuffer;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferWriteFeature
implements MultipartWrite<Void> {
    private static final Logger log = LogManager.getLogger(BufferWriteFeature.class);
    private final Session<?> session;

    public BufferWriteFeature(Session<?> session) {
        this.session = session;
    }

    @Override
    public StatusOutputStream<Void> write(final Path file, final TransferStatus status, final ConnectionCallback callback) {
        final FileBuffer buffer = new FileBuffer();
        return new VoidStatusOutputStream((OutputStream)((Object)new BufferOutputStream(buffer){
            private final AtomicBoolean close;
            {
                super(buffer2);
                this.close = new AtomicBoolean();
            }

            public void flush() {
            }

            public void close() throws IOException {
                try {
                    if (this.close.get()) {
                        log.warn(String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    final TransferStatus range = new TransferStatus(status).withLength(buffer.length()).append(false);
                    if (0L == buffer.length()) {
                        BufferWriteFeature.this.session._getFeature(Touch.class).touch(file, new TransferStatus());
                    } else {
                        final StatusOutputStream out = BufferWriteFeature.this.session._getFeature(Write.class).write(file, range, callback);
                        new DefaultRetryCallable<Void>(BufferWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                            @Override
                            public Void call() throws BackgroundException {
                                try {
                                    IOUtils.copy((InputStream)new BufferInputStream(buffer), (OutputStream)((Object)out));
                                    out.close();
                                    log.info(String.format("Completed upload for %s with status %s", file, range));
                                    return null;
                                }
                                catch (IOException e) {
                                    throw new DefaultIOExceptionMappingService().map(e);
                                }
                            }
                        }, (StreamCancelation)status){

                            @Override
                            public boolean retry(BackgroundException failure, ProgressListener progress, BackgroundActionState cancel) {
                                if (failure instanceof InteroperabilityException) {
                                    return super.retry(new RetriableAccessDeniedException(failure.getDetail(), failure), progress, cancel);
                                }
                                return super.retry(failure, progress, cancel);
                            }
                        }.call();
                    }
                    super.close();
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    this.close.set(true);
                }
            }
        }));
    }

    @Override
    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }
}

