/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.dd;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.serializer.Reader;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class PlistReader<S extends Serializable>
implements Reader<S> {
    @Override
    public S read(Local file) throws AccessDeniedException {
        if (!file.exists()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        if (!file.isFile()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        S deserialized = this.read(file.getInputStream());
        if (null == deserialized) {
            throw new AccessDeniedException(String.format("Failure parsing file %s", file.getName()));
        }
        return deserialized;
    }

    @Override
    public S read(InputStream in) throws AccessDeniedException {
        NSDictionary dict = (NSDictionary)this.parse(in);
        return this.deserialize(dict);
    }

    private NSObject parse(InputStream in) throws AccessDeniedException {
        try {
            return XMLPropertyListParser.parse((InputStream)in);
        }
        catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            throw new AccessDeniedException("Failure parsing XML property list", e);
        }
    }

    public abstract S deserialize(NSDictionary var1);
}

