/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.dd;

import ch.cyberduck.core.serializer.Deserializer;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlistDeserializer
implements Deserializer<NSDictionary> {
    private static final Logger log = LogManager.getLogger(PlistDeserializer.class);
    final NSDictionary dict;

    public PlistDeserializer(NSDictionary dict) {
        this.dict = dict;
    }

    @Override
    public String stringForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean booleanForKey(String key) {
        String value = this.stringForKey(key);
        if (null == value) {
            return false;
        }
        if (value.equalsIgnoreCase(String.valueOf(1))) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public NSDictionary objectForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value instanceof NSDictionary) {
            return (NSDictionary)value;
        }
        log.warn(String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    @Override
    public <T> List<T> listForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value instanceof NSArray) {
            NSArray array = (NSArray)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < array.count(); ++i) {
                NSObject next = array.objectAtIndex(i);
                if (next instanceof NSDictionary) {
                    list.add(next);
                    continue;
                }
                if (next instanceof NSString) {
                    list.add(next.toString());
                    continue;
                }
                log.warn(String.format("Ignore content of type %s", next));
            }
            return list;
        }
        log.warn(String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    @Override
    public Map<String, String> mapForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value instanceof NSDictionary) {
            NSDictionary dict = (NSDictionary)value;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String k : dict.allKeys()) {
                map.put(k, dict.objectForKey(k).toString());
            }
            return map;
        }
        log.warn(String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    @Override
    public List<String> keys() {
        return new ArrayList<String>(this.dict.keySet());
    }
}

