/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.transfer.TransferItem;

public class TransferItemDictionary<T> {
    private final DeserializerFactory<T> deserializer;

    public TransferItemDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public TransferItemDictionary(DeserializerFactory<T> deserializer) {
        this.deserializer = deserializer;
    }

    public TransferItem deserialize(T serialized) {
        Deserializer<T> dict = this.deserializer.create(serialized);
        Path remote = new PathDictionary<T>(this.deserializer).deserialize(dict.objectForKey("Remote"));
        if (null == remote) {
            return null;
        }
        TransferItem item = new TransferItem(remote);
        T localObj = dict.objectForKey("Local Dictionary");
        if (localObj != null) {
            item.setLocal(new LocalDictionary<T>(this.deserializer).deserialize(localObj));
        }
        return item;
    }
}

