/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfileDictionary<T> {
    private static final Logger log = LogManager.getLogger(ProfileDictionary.class);
    private final DeserializerFactory<T> deserializer;
    private final ProtocolFactory protocols;

    public ProfileDictionary() {
        this(ProtocolFactory.get());
    }

    public ProfileDictionary(ProtocolFactory protocols) {
        this(protocols, new DeserializerFactory());
    }

    public ProfileDictionary(DeserializerFactory<T> deserializer) {
        this(ProtocolFactory.get(), deserializer);
    }

    public ProfileDictionary(ProtocolFactory protocols, DeserializerFactory<T> deserializer) {
        this.protocols = protocols;
        this.deserializer = deserializer;
    }

    public Profile deserialize(T serialized, Predicate<Protocol> filter) {
        Deserializer<T> dict = this.deserializer.create(serialized);
        String protocol = dict.stringForKey("Protocol");
        if (StringUtils.isNotBlank((CharSequence)protocol)) {
            Protocol parent = this.protocols.forName(this.protocols.find(filter), protocol, null);
            if (null == parent) {
                log.error(String.format("Unknown protocol %s in profile. Try fallback with no predicate in lookup", protocol));
                parent = this.protocols.forName(this.protocols.find(p -> true), protocol, null);
            }
            if (null == parent) {
                return null;
            }
            return new Profile(parent, dict);
        }
        log.error("Missing protocol in profile");
        return null;
    }
}

