/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathDictionary<T> {
    private static final Logger log = LogManager.getLogger(PathDictionary.class);
    private final DeserializerFactory<T> factory;

    public PathDictionary() {
        this.factory = new DeserializerFactory();
    }

    public PathDictionary(DeserializerFactory<T> factory) {
        this.factory = factory;
    }

    public Path deserialize(T serialized) {
        Path path;
        T attributesObj;
        Deserializer<T> dict = this.factory.create(serialized);
        EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
        String typeObj = dict.stringForKey("Type");
        if (typeObj != null) {
            for (String t : StringUtils.splitByWholeSeparator((String)StringUtils.replaceEach((String)typeObj, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""}), (String)", ")) {
                try {
                    type.add(AbstractPath.Type.valueOf(t));
                }
                catch (IllegalArgumentException e) {
                    log.warn(String.format("Unknown type %s", t));
                }
            }
        }
        if ((attributesObj = dict.objectForKey("Attributes")) != null) {
            PathAttributes attributes = new PathAttributesDictionary<T>(this.factory).deserialize(attributesObj);
            String legacyTypeObj = this.factory.create(attributesObj).stringForKey("Type");
            if (legacyTypeObj != null) {
                if ((Integer.parseInt(legacyTypeObj) & AbstractPath.Type.file.legacy()) == AbstractPath.Type.file.legacy()) {
                    type.add(AbstractPath.Type.file);
                }
                if ((Integer.parseInt(legacyTypeObj) & AbstractPath.Type.directory.legacy()) == AbstractPath.Type.directory.legacy()) {
                    type.add(AbstractPath.Type.directory);
                }
                if ((Integer.parseInt(legacyTypeObj) & AbstractPath.Type.symboliclink.legacy()) == AbstractPath.Type.symboliclink.legacy()) {
                    type.add(AbstractPath.Type.symboliclink);
                }
                if ((Integer.parseInt(legacyTypeObj) & AbstractPath.Type.volume.legacy()) == AbstractPath.Type.volume.legacy()) {
                    type.add(AbstractPath.Type.volume);
                }
            }
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type, attributes);
        } else {
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type);
        }
        T symlinkObj = dict.objectForKey("Symbolic Link");
        if (symlinkObj != null) {
            path.setSymlinkTarget(new PathDictionary<T>(this.factory).deserialize(symlinkObj));
        }
        return path;
    }
}

