/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.List;

public class AclDictionary<T> {
    private final DeserializerFactory<T> deserializer;

    public AclDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public AclDictionary(DeserializerFactory<T> deserializer) {
        this.deserializer = deserializer;
    }

    public Acl deserialize(T serialized) {
        Deserializer<T> dict = this.deserializer.create(serialized);
        Acl acl = new Acl(new Acl.UserAndRole[0]);
        List<String> keys = dict.keys();
        for (String key : keys) {
            List rolesObj = dict.listForKey(key);
            for (Object roleObj : rolesObj) {
                Acl.Role role = new Acl.RoleDictionary(this.deserializer).deserialize(roleObj);
                acl.addAll(new Acl.CanonicalUser(key), role);
            }
        }
        return acl;
    }
}

