/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.proxy;

import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFinder;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;

public class DefaultProxyFinder
implements ProxyFinder {
    private final ProxySelector selector = ProxySelector.getDefault();
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public Proxy find(String target) {
        for (java.net.Proxy proxy : this.selector.select(URI.create(target))) {
            switch (proxy.type()) {
                case DIRECT: {
                    return Proxy.DIRECT;
                }
                case HTTP: {
                    if (proxy.address() instanceof InetSocketAddress) {
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        return new Proxy(Proxy.Type.HTTP, address.getHostName(), address.getPort());
                    }
                }
                case SOCKS: {
                    if (!(proxy.address() instanceof InetSocketAddress)) break;
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    return new Proxy(Proxy.Type.SOCKS, address.getHostName(), address.getPort());
                }
            }
        }
        return Proxy.DIRECT;
    }
}

