/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import ch.cyberduck.core.profiles.RemoteProfileDescription;
import ch.cyberduck.core.shared.DefaultPathHomeFeature;
import ch.cyberduck.core.shared.DelegatingHomeFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteProfilesFinder
implements ProfilesFinder {
    private static final Logger log = LogManager.getLogger(RemoteProfilesFinder.class);
    private final ProtocolFactory protocols;
    private final Session<?> session;

    public RemoteProfilesFinder(Session<?> session) {
        this(ProtocolFactory.get(), session);
    }

    public RemoteProfilesFinder(ProtocolFactory protocols, Session<?> session) {
        this.protocols = protocols;
        this.session = session;
    }

    @Override
    public Set<ProfileDescription> find(ProfilesFinder.Visitor visitor) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Fetch profiles from %s", this.session.getHost()));
        }
        ProfileFilter filter = new ProfileFilter();
        AttributedList<Path> list = this.session.getFeature(ListService.class).list(new DelegatingHomeFeature(new DefaultPathHomeFeature(this.session.getHost())).find(), new DisabledListProgressListener());
        return list.filter(filter).toStream().map(file -> visitor.visit(new RemoteProfileDescription(this.protocols, (Path)file, new LazyInitializer<Local>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Local initialize() throws ConcurrentException {
                try {
                    Read read = RemoteProfilesFinder.this.session.getFeature(Read.class);
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Download profile %s", file));
                    }
                    InputStream in = read.read(file.withAttributes(new PathAttributes(file.attributes()).withVersionId(null)), new TransferStatus().withLength(-1L), new DisabledConnectionCallback());
                    Local temp = TemporaryFileServiceFactory.get().create(file.getName());
                    OutputStream out = temp.getOutputStream(false);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        in.close();
                        out.close();
                    }
                    return temp;
                }
                catch (BackgroundException | IOException e) {
                    throw new ConcurrentException((Throwable)e);
                }
            }
        }))).collect(Collectors.toSet());
    }

    private static final class ProfileFilter
    implements Filter<Path> {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(Path file) {
            if (file.isFile()) {
                return "cyberduckprofile".equals(Path.getExtension(file.getName()));
            }
            return false;
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberduckprofile");
        }
    }
}

