/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.profiles.ChecksumProfileMatcher;
import ch.cyberduck.core.profiles.LocalProfileDescription;
import ch.cyberduck.core.profiles.LocalProfilesFinder;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import ch.cyberduck.core.profiles.RemoteProfilesFinder;
import ch.cyberduck.core.worker.Worker;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfilesSynchronizeWorker
extends Worker<Set<ProfileDescription>> {
    private static final Logger log = LogManager.getLogger((String)ProfilesSynchronizeWorker.class.getName());
    private final ProtocolFactory registry;
    private final Local directory;
    private final ProfilesFinder.Visitor visitor;

    public ProfilesSynchronizeWorker(ProfilesFinder.Visitor visitor) {
        this(ProtocolFactory.get(), visitor);
    }

    public ProfilesSynchronizeWorker(ProtocolFactory registry, ProfilesFinder.Visitor visitor) {
        this(registry, LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")), visitor);
    }

    public ProfilesSynchronizeWorker(ProtocolFactory registry, Local directory, ProfilesFinder.Visitor visitor) {
        this.registry = registry;
        this.directory = directory;
        this.visitor = visitor;
    }

    @Override
    public Set<ProfileDescription> initialize() {
        try {
            return new LocalProfilesFinder(this.registry, this.directory, ProtocolFactory.BUNDLED_PROFILE_PREDICATE).find();
        }
        catch (BackgroundException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public Set<ProfileDescription> run(Session<?> session) throws BackgroundException {
        HashSet<ProfileDescription> returned = new HashSet<ProfileDescription>();
        Set<ProfileDescription> installed = new LocalProfilesFinder(this.registry, this.directory, ProtocolFactory.BUNDLED_PROFILE_PREDICATE).find();
        Set<ProfileDescription> remote = new RemoteProfilesFinder(this.registry, session).find();
        ChecksumProfileMatcher matcher = new ChecksumProfileMatcher(remote);
        installed.forEach(local -> {
            Optional<ProfileDescription> match = matcher.compare((ProfileDescription)local);
            if (match.isPresent()) {
                log.warn(String.format("Override %s with latest profile verison %s", local, match));
                local.getProfile().ifPresent(this.registry::unregister);
                match.get().getFile().ifPresent(value -> {
                    Local copy = this.registry.register((Local)value);
                    if (null != copy) {
                        LocalProfileDescription d = new LocalProfileDescription(this.registry, copy);
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Add synched profile %s", d));
                        }
                        returned.add(d);
                        this.visitor.visit(d);
                    }
                });
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add local only profile %s", local));
                }
                returned.add((ProfileDescription)local);
                this.visitor.visit((ProfileDescription)local);
            }
        });
        remote.forEach(description -> {
            if (description.isLatest() && !returned.contains(description)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add remote profile %s", description));
                }
                returned.add((ProfileDescription)description);
                this.visitor.visit((ProfileDescription)description);
            }
        });
        return returned;
    }
}

