/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.serializer.impl.dd.ProfilePlistReader;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfileDescription {
    private static final Logger log = LogManager.getLogger(ProfileDescription.class);
    private final LazyInitializer<Checksum> checksum;
    private final LazyInitializer<Local> local;
    private final LazyInitializer<Profile> profile;

    public ProfileDescription(ProtocolFactory protocols, Checksum checksum, Local local) {
        this(protocols, (Protocol protocol) -> true, checksum, local);
    }

    public ProfileDescription(ProtocolFactory protocols, Predicate<Protocol> parent, final Checksum checksum, final Local local) {
        this(protocols, parent, new LazyInitializer<Checksum>(){

            protected Checksum initialize() {
                return checksum;
            }
        }, new LazyInitializer<Local>(){

            protected Local initialize() {
                return local;
            }
        });
    }

    public ProfileDescription(final ProtocolFactory protocols, final Predicate<Protocol> parent, LazyInitializer<Checksum> checksum, final LazyInitializer<Local> local) {
        this.checksum = checksum;
        this.local = local;
        this.profile = new LazyInitializer<Profile>(){

            protected Profile initialize() throws ConcurrentException {
                try {
                    return (Profile)new ProfilePlistReader(protocols, parent).read((Local)local.get());
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Failure %s reading profile %s", e, e));
                    throw new ConcurrentException((Throwable)e);
                }
            }
        };
    }

    public Checksum getChecksum() {
        try {
            return (Checksum)this.checksum.get();
        }
        catch (ConcurrentException e) {
            return Checksum.NONE;
        }
    }

    public Optional<Local> getFile() {
        try {
            return Optional.of((Local)this.local.get());
        }
        catch (ConcurrentException e) {
            return Optional.empty();
        }
    }

    public Optional<Profile> getProfile() {
        try {
            return Optional.of((Profile)this.profile.get());
        }
        catch (ConcurrentException e) {
            return Optional.empty();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileDescription)) {
            return false;
        }
        ProfileDescription that = (ProfileDescription)o;
        try {
            return Objects.equals(this.checksum.get(), that.checksum.get());
        }
        catch (ConcurrentException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Objects.hash(this.checksum.get());
        }
        catch (ConcurrentException e) {
            return Objects.hash(Checksum.NONE);
        }
    }

    public boolean isLatest() {
        return true;
    }

    public boolean isInstalled() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProfileDescription{");
        sb.append("checksum=").append(this.checksum);
        sb.append(", profile=").append(this.local);
        sb.append('}');
        return sb.toString();
    }
}

