/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import ch.cyberduck.core.profiles.ProfilesSynchronizeWorker;
import ch.cyberduck.core.profiles.ProfilesUpdater;
import ch.cyberduck.core.profiles.ProfilesWorkerBackgroundAction;
import java.time.Duration;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodicProfilesUpdater
implements ProfilesUpdater {
    private static final Logger log = LogManager.getLogger((String)PeriodicProfilesUpdater.class.getName());
    private final Controller controller;
    private final Duration delay;
    private final Timer timer = new Timer("profiles", true);

    public PeriodicProfilesUpdater(Controller controller) {
        this(controller, Duration.ofSeconds(PreferencesFactory.get().getLong("update.check.interval")));
    }

    public PeriodicProfilesUpdater(Controller controller, Duration delay) {
        this.controller = controller;
        this.delay = delay;
    }

    @Override
    public void unregister() {
        this.timer.cancel();
    }

    @Override
    public void register() {
        log.info(String.format("Register profiles checker hook after %s", this.delay));
        try {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Check for new profiles after %s", PeriodicProfilesUpdater.this.delay));
                    }
                    try {
                        PeriodicProfilesUpdater.this.synchronize(ProfilesFinder.Visitor.Noop);
                    }
                    catch (BackgroundException e) {
                        log.warn(String.format("Failure %s refreshing profiles", e));
                    }
                }
            }, 0L, this.delay.toMillis());
        }
        catch (IllegalStateException e) {
            log.warn(String.format("Failure scheduling timer. %s", e.getMessage()));
        }
    }

    public Future<Set<ProfileDescription>> synchronize(ProfilesFinder.Visitor visitor) throws BackgroundException {
        return this.controller.background(new ProfilesWorkerBackgroundAction(this.controller, new ProfilesSynchronizeWorker(visitor)));
    }
}

