/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.profiles.LocalProfileDescription;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalProfilesFinder
implements ProfilesFinder {
    private static final Logger log = LogManager.getLogger(LocalProfilesFinder.class);
    private final ProtocolFactory protocols;
    private final Local directory;
    private final Predicate<Protocol> parent;

    public LocalProfilesFinder(ProtocolFactory protocols, Local directory) {
        this(protocols, directory, protocol -> true);
    }

    public LocalProfilesFinder(ProtocolFactory protocols, Local directory, Predicate<Protocol> parent) {
        this.protocols = protocols;
        this.directory = directory;
        this.parent = parent;
    }

    @Override
    public Set<ProfileDescription> find(ProfilesFinder.Visitor visitor) throws AccessDeniedException {
        if (this.directory.exists()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Load profiles from %s", this.directory));
            }
            return this.directory.list().filter(new ProfileFilter()).toList().stream().map(file -> visitor.visit(new LocalProfileDescription(this.protocols, this.parent, (Local)file))).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static final class ProfileFilter
    implements Filter<Local> {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "cyberduckprofile".equals(Path.getExtension(file.getName()));
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberduckprofile");
        }
    }
}

