/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.function.Predicate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public final class LocalProfileDescription
extends ProfileDescription {
    private final Local file;

    public LocalProfileDescription(ProtocolFactory protocols, Local file) {
        this(protocols, (Protocol protocol) -> true, file);
    }

    public LocalProfileDescription(ProtocolFactory protocols, Predicate<Protocol> parent, final Local file) {
        super(protocols, parent, new LazyInitializer<Checksum>(){

            protected Checksum initialize() throws ConcurrentException {
                try {
                    return ChecksumComputeFactory.get(HashAlgorithm.md5).compute(file.getInputStream(), new TransferStatus());
                }
                catch (BackgroundException e) {
                    throw new ConcurrentException((Throwable)e);
                }
            }
        }, new LazyInitializer<Local>(){

            protected Local initialize() {
                return file;
            }
        });
        this.file = file;
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LocalProfileDescription{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

