/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.profiles;

import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfileMatcher;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumProfileMatcher
implements ProfileMatcher {
    private static final Logger log = LogManager.getLogger((String)ChecksumProfileMatcher.class.getName());
    private final Set<ProfileDescription> repository;

    public ChecksumProfileMatcher(Set<ProfileDescription> repository) {
        this.repository = repository;
    }

    @Override
    public Optional<ProfileDescription> compare(ProfileDescription next) {
        Optional<ProfileDescription> found = this.repository.stream().filter(description -> Objects.equals(description.getChecksum(), next.getChecksum())).findFirst();
        if (found.isPresent()) {
            if (found.get().isLatest()) {
                return Optional.empty();
            }
            return found;
        }
        log.warn(String.format("Local only profile %s", next));
        return Optional.empty();
    }
}

