/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface PreferencesReader {
    public static final Logger log = LogManager.getLogger(PreferencesReader.class);

    public String getProperty(String var1);

    public List<String> getList(String var1);

    default public Map<String, String> getMap(String property) {
        List<String> list = this.getList(property);
        HashMap<String, String> table = new HashMap<String, String>();
        for (String m : list) {
            if (StringUtils.isBlank((CharSequence)m)) continue;
            if (!m.contains("=")) {
                log.warn(String.format("Invalid header %s", m));
                continue;
            }
            int split = m.indexOf(61);
            String key = m.substring(0, split);
            if (StringUtils.isBlank((CharSequence)key)) {
                log.warn(String.format("Missing key in %s", m));
                continue;
            }
            String value = m.substring(split + 1);
            if (StringUtils.isEmpty((CharSequence)value)) {
                log.warn(String.format("Missing value in %s", m));
                continue;
            }
            table.put(key, value);
        }
        return table;
    }

    public static List<String> toList(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split("(?<!\\\\)\\p{javaWhitespace}+"));
    }

    public int getInteger(String var1);

    public static int toInteger(String v) {
        if (null == v) {
            return -1;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return (int)PreferencesReader.toDouble(v);
        }
    }

    public float getFloat(String var1);

    public static float toFloat(String v) {
        if (null == v) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return (float)PreferencesReader.toDouble(v);
        }
    }

    public long getLong(String var1);

    public static long toLong(String v) {
        if (null == v) {
            return -1L;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return (long)PreferencesReader.toDouble(v);
        }
    }

    public double getDouble(String var1);

    public static double toDouble(String v) {
        if (null == v) {
            return -1.0;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public boolean getBoolean(String var1);

    public static boolean toBoolean(String v) {
        if (null == v) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(true))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(false))) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(1))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(0))) {
            return false;
        }
        return v.equalsIgnoreCase("yes");
    }
}

