/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.MemoryPreferences;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PreferencesFactory {
    private static Preferences preferences;

    private PreferencesFactory() {
    }

    public static synchronized void set(Preferences p) {
        preferences = p;
        preferences.load();
        preferences.setFactories();
        preferences.setDefaults();
        preferences.setDefaults(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "default.properties"));
        preferences.configureLogging(preferences.getProperty("logging"));
        Logger log = LogManager.getLogger(PreferencesFactory.class);
        if (log.isInfoEnabled()) {
            log.info(String.format("Running version %s.%s (%s)", preferences.getProperty("application.version"), preferences.getProperty("application.revision"), preferences.getProperty("application.hash")));
        }
    }

    public static synchronized Preferences get() {
        if (null == preferences) {
            PreferencesFactory.set(new DefaultLoggingMemoryPreferenes());
        }
        return preferences;
    }

    private static final class DefaultLoggingMemoryPreferenes
    extends MemoryPreferences {
        private DefaultLoggingMemoryPreferenes() {
        }

        @Override
        protected void configureLogging(String level) {
            this.setDefault("logging.config", "log4j.xml");
            super.configureLogging(level);
        }
    }
}

