/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.core.DefaultConnectionTimeout;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.DisabledCertificateIdentityCallback;
import ch.cyberduck.core.DisabledCertificateStore;
import ch.cyberduck.core.DisabledCertificateTrustCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLocale;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.DisabledSleepPreventer;
import ch.cyberduck.core.DisabledTerminalService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PreferencesProxyCredentialsStore;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.aquaticprime.DonationKeyFactory;
import ch.cyberduck.core.date.DefaultUserDateFormatter;
import ch.cyberduck.core.diagnostics.DisabledReachability;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.formatter.DecimalSizeFormatter;
import ch.cyberduck.core.i18n.Locales;
import ch.cyberduck.core.io.watchservice.NIOEventWatchService;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.DefaultTemporaryFileService;
import ch.cyberduck.core.local.DefaultWorkingDirectoryFinder;
import ch.cyberduck.core.local.DisabledApplicationBadgeLabeler;
import ch.cyberduck.core.local.DisabledApplicationFinder;
import ch.cyberduck.core.local.DisabledApplicationLauncher;
import ch.cyberduck.core.local.DisabledBrowserLauncher;
import ch.cyberduck.core.local.DisabledFilesystemBookmarkResolver;
import ch.cyberduck.core.local.DisabledIconService;
import ch.cyberduck.core.local.DisabledQuarantineService;
import ch.cyberduck.core.local.NativeLocalTrashFeature;
import ch.cyberduck.core.local.NullFileDescriptor;
import ch.cyberduck.core.local.NullLocalSymlinkFeature;
import ch.cyberduck.core.notification.DisabledNotificationFilterService;
import ch.cyberduck.core.notification.DisabledNotificationService;
import ch.cyberduck.core.preferences.DisabledApplicationLoginRegistry;
import ch.cyberduck.core.preferences.LogDirectoryFinderFactory;
import ch.cyberduck.core.preferences.PreferencesReader;
import ch.cyberduck.core.preferences.SupportDirectoryLogDirectoryFinder;
import ch.cyberduck.core.preferences.TemporaryApplicationResourcesFinder;
import ch.cyberduck.core.preferences.TemporarySupportDirectoryFinder;
import ch.cyberduck.core.proxy.DisabledProxyFinder;
import ch.cyberduck.core.random.DefaultSecureRandomProvider;
import ch.cyberduck.core.resources.DisabledIconCache;
import ch.cyberduck.core.serializer.impl.dd.HostPlistReader;
import ch.cyberduck.core.serializer.impl.dd.PlistDeserializer;
import ch.cyberduck.core.serializer.impl.dd.PlistSerializer;
import ch.cyberduck.core.serializer.impl.dd.PlistWriter;
import ch.cyberduck.core.serializer.impl.dd.ProfilePlistReader;
import ch.cyberduck.core.serializer.impl.dd.TransferPlistReader;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.DisabledActionOperationBatcher;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.updater.DisabledPeriodicUpdater;
import ch.cyberduck.core.updater.DisabledUpdateCheckerArguments;
import ch.cyberduck.core.urlhandler.DisabledSchemeHandler;
import ch.cyberduck.core.vault.DisabledVault;
import ch.cyberduck.core.webloc.InternetShortcutFileWriter;
import ch.cyberduck.ui.quicklook.ApplicationLauncherQuicklook;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class Preferences
implements Locales,
PreferencesReader {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(Preferences.class);
    protected static final String LIST_SEPERATOR = " ";

    public abstract void setProperty(String var1, String var2);

    public void setProperty(String property, List<String> values) {
        this.setProperty(property, StringUtils.join(values, (String)LIST_SEPERATOR));
    }

    public abstract void deleteProperty(String var1);

    public void setProperty(String property, boolean v) {
        this.setProperty(property, v ? String.valueOf(true) : String.valueOf(false));
    }

    public void setProperty(String property, int v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, float v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, long v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, double v) {
        this.setProperty(property, String.valueOf(v));
    }

    public abstract String getDefault(String var1);

    public abstract void setDefault(String var1, String var2);

    protected void setDefaults(Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.setDefault(property.getKey().toString(), property.getValue().toString());
        }
    }

    protected void setDefaults(Local defaults) {
        if (defaults.exists()) {
            Properties props = new Properties();
            try (InputStream in = defaults.getInputStream();){
                props.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            }
            catch (AccessDeniedException | IOException | IllegalArgumentException exception) {
                // empty catch block
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.setDefault(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    protected void setDefaults() {
        Security.setProperty("networkaddress.cache.ttl", "10");
        Security.setProperty("networkaddress.cache.negative.ttl", "5");
        Version version = new Version();
        this.setDefault("application.version", StringUtils.substringBeforeLast((String)version.getSpecification(), (String)"."));
        this.setDefault("application.revision", StringUtils.substringAfterLast((String)version.getSpecification(), (String)"."));
        this.setDefault("application.hash", version.getImplementation());
        this.setDefault("tmp.dir", System.getProperty("java.io.tmpdir"));
        this.setDefault("uses", "0");
        this.setDefault("donate.reminder", String.valueOf(-1));
        this.setDefault("donate.reminder.suppress.enable", String.valueOf(false));
        this.setDefault("donate.reminder.interval", String.valueOf(0));
        this.setDefault("donate.reminder.date", String.valueOf(new Date(0L).getTime()));
        this.setDefault("defaulthandler.reminder", String.valueOf(true));
        this.setDefault("mail.feedback", "mailto:support@cyberduck.io");
        this.setDefault("website.donate", "https://cyberduck.io/donate/");
        this.setDefault("website.home", "https://cyberduck.io/");
        this.setDefault("website.help", "https://help.cyberduck.io/" + this.locale());
        this.setDefault("website.bug", "https://trac.cyberduck.io/newticket?version={0}");
        this.setDefault("website.crash", "https://crash.cyberduck.io/report");
        this.setDefault("website.cli", "https://duck.sh/");
        this.setDefault("website.license", "https://cyberduck.io/license");
        this.setDefault("website.acknowledgments", "https://cyberduck.io/acknowledgments");
        this.setDefault("website.privacypolicy", "https://cyberduck.io/privacy/");
        this.setDefault("rendezvous.enable", String.valueOf(true));
        this.setDefault("rendezvous.loopback.suppress", String.valueOf(true));
        this.setDefault("rendezvous.notification.limit", String.valueOf(0));
        this.setDefault("growl.enable", String.valueOf(true));
        this.setDefault("path.symboliclink.resolve", String.valueOf(false));
        this.setDefault("path.normalize", String.valueOf(true));
        this.setDefault("path.normalize.unicode", String.valueOf(false));
        this.setDefault("local.user.home", System.getProperty("user.home"));
        this.setDefault("local.alias.resolve", String.valueOf(true));
        this.setDefault("local.symboliclink.resolve", String.valueOf(false));
        this.setDefault("local.normalize.prefix", String.valueOf(false));
        this.setDefault("local.normalize.unicode", String.valueOf(true));
        this.setDefault("local.normalize.tilde", String.valueOf(true));
        this.setDefault("local.delimiter", File.separator);
        this.setDefault("local.temporaryfiles.shortening.threshold", String.valueOf(240));
        this.setDefault("application.identifier", "io.cyberduck");
        this.setDefault("application.name", "Cyberduck");
        this.setDefault("application.container.name", "duck");
        this.setDefault("application.container.teamidentifier", "G69SCX94XU");
        this.setDefault("application.datafolder.name", "duck");
        this.setDefault("bookmarks.folder.name", "Bookmarks");
        this.setDefault("bookmarks.folder.monitor", String.valueOf(true));
        this.setDefault("profiles.folder.name", "Profiles");
        this.setDefault("profiles.discovery.updater.enable", String.valueOf(false));
        this.setDefault("profiles.discovery.updater.url", "s3://djynunjb246r8.cloudfront.net");
        this.setDefault("browser.cache.size", String.valueOf(1000));
        this.setDefault("transfer.cache.size", String.valueOf(100));
        this.setDefault("icon.cache.size", String.valueOf(200));
        this.setDefault("preferences.cache.size", String.valueOf(1000));
        this.setDefault("fileid.cache.size", String.valueOf(10000));
        this.setDefault("browser.model.cache.size", String.valueOf(10000));
        this.setDefault("browser.list.limit.directory", String.valueOf(5000));
        this.setDefault("browser.list.limit.container", String.valueOf(100));
        this.setDefault("info.toolbar.selected", String.valueOf(0));
        this.setDefault("preferences.toolbar.selected", String.valueOf(0));
        this.setDefault("browser.view", "1");
        this.setDefault("browser.serialize", String.valueOf(true));
        this.setDefault("browser.font.size", String.valueOf(12.0f));
        this.setDefault("browser.view.autoexpand", String.valueOf(true));
        this.setDefault("browser.view.autoexpand.delay.enable", String.valueOf(true));
        this.setDefault("browser.view.autoexpand.delay", "1.0");
        this.setDefault("browser.hidden.regex", "\\..*");
        this.setDefault("browser.open.untitled", String.valueOf(true));
        this.setDefault("browser.open.bookmark.default", null);
        this.setDefault("browser.disconnect.confirm", String.valueOf(false));
        this.setDefault("browser.disconnect.bookmarks.show", String.valueOf(false));
        this.setDefault("browser.info.inspector", String.valueOf(true));
        this.setDefault("browser.sort.ascending", String.valueOf(true));
        this.setDefault("browser.alternatingRows", String.valueOf(false));
        this.setDefault("browser.verticalLines", String.valueOf(false));
        this.setDefault("browser.horizontalLines", String.valueOf(true));
        this.setDefault("browser.showHidden", String.valueOf(false));
        this.setDefault("browser.charset.encoding", StandardCharsets.UTF_8.name());
        this.setDefault("browser.doubleclick.edit", String.valueOf(false));
        this.setDefault("browser.enterkey.rename", String.valueOf(true));
        this.setDefault("browser.editable", String.valueOf(true));
        this.setDefault("browser.move.confirm", String.valueOf(true));
        this.setDefault("browser.copy.confirm", String.valueOf(false));
        this.setDefault("browser.transcript.open", String.valueOf(false));
        this.setDefault("browser.transcript.size.height", String.valueOf(200));
        this.setDefault("browser.duplicate.format", "{0} ({1}){2}");
        this.setDefault("browser.delete.trash", String.valueOf(true));
        this.setDefault("browser.filesize.decimal", String.valueOf(false));
        this.setDefault("browser.date.natural", String.valueOf(true));
        this.setDefault("bookmark.toggle.options", String.valueOf(false));
        this.setDefault("transfer.toggle.details", String.valueOf(true));
        this.setDefault("editor.bundleIdentifier", "com.apple.TextEdit");
        this.setDefault("editor.alwaysUseDefault", String.valueOf(false));
        this.setDefault("editor.upload.permissions.change", String.valueOf(true));
        this.setDefault("editor.upload.symboliclink.resolve", String.valueOf(true));
        this.setDefault("favorites.save", String.valueOf(true));
        this.setDefault("queue.removeItemWhenComplete", String.valueOf(false));
        this.setDefault("queue.transfer.type.enabled", String.format("%s %s %s", Host.TransferType.browser.name(), Host.TransferType.newconnection.name(), Host.TransferType.concurrent.name()));
        this.setDefault("queue.transfer.type", Host.TransferType.concurrent.name());
        this.setDefault("queue.transfer.operationbatcher.size", String.valueOf(100));
        this.setDefault("queue.size.warn", String.valueOf(20));
        this.setDefault("queue.window.open.default", String.valueOf(false));
        this.setDefault("queue.window.open.transfer.start", String.valueOf(true));
        this.setDefault("queue.window.open.transfer.stop", String.valueOf(false));
        this.setDefault("queue.download.action", TransferAction.callback.name());
        this.setDefault("queue.upload.action", TransferAction.callback.name());
        this.setDefault("queue.copy.action", TransferAction.callback.name());
        this.setDefault("queue.download.reload.action", TransferAction.callback.name());
        this.setDefault("queue.upload.reload.action", TransferAction.callback.name());
        this.setDefault("queue.copy.reload.action", TransferAction.callback.name());
        this.setDefault("queue.upload.permissions.change", String.valueOf(false));
        this.setDefault("queue.upload.acl.change", String.valueOf(true));
        this.setDefault("queue.upload.permissions.default", String.valueOf(false));
        this.setDefault("queue.upload.permissions.file.default", String.valueOf(644));
        this.setDefault("queue.upload.permissions.folder.default", String.valueOf(755));
        this.setDefault("queue.upload.timestamp.change", String.valueOf(false));
        this.setDefault("queue.upload.file.metadata.change", String.valueOf(true));
        this.setDefault("queue.upload.file.encryption.change", String.valueOf(true));
        this.setDefault("queue.upload.file.redundancy.change", String.valueOf(true));
        this.setDefault("queue.upload.checksum.calculate", String.valueOf(false));
        this.setDefault("queue.upload.skip.enable", String.valueOf(true));
        this.setDefault("queue.upload.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS|\\.git|\\.gitignore|\\.gitattributes|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags");
        this.setDefault("queue.upload.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS|\\.git|\\.gitignore|\\.gitattributes|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags");
        this.setDefault("queue.upload.priority.regex", "");
        this.setDefault("queue.upload.file.temporary", String.valueOf(false));
        this.setDefault("queue.upload.file.temporary.format", "{0}-{1}");
        this.setDefault("queue.upload.file.rename.format", "{0} ({1}){2}");
        this.setDefault("queue.download.file.rename.format", "{0} ({1}){2}");
        this.setDefault("queue.download.permissions.change", String.valueOf(true));
        this.setDefault("queue.download.permissions.default", String.valueOf(false));
        this.setDefault("queue.download.permissions.file.default", String.valueOf(644));
        this.setDefault("queue.download.permissions.folder.default", String.valueOf(755));
        this.setDefault("queue.download.timestamp.change", String.valueOf(true));
        this.setDefault("queue.download.checksum.calculate", String.valueOf(false));
        this.setDefault("queue.download.skip.enable", String.valueOf(true));
        this.setDefault("queue.download.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.setDefault("queue.download.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.setDefault("queue.download.priority.regex", "");
        this.setDefault("queue.download.folder", System.getProperty("user.dir"));
        this.setDefault("queue.download.folder.bookmark", null);
        this.setDefault("queue.download.quarantine", String.valueOf(true));
        this.setDefault("queue.download.wherefrom", String.valueOf(true));
        this.setDefault("queue.download.segments", String.valueOf(true));
        this.setDefault("queue.download.segments.threshold", String.valueOf(0xA00000L));
        this.setDefault("queue.download.segments.size", String.valueOf(0x8000000L));
        this.setDefault("queue.download.segments.count", String.valueOf(128));
        this.setDefault("queue.download.complete.open", String.valueOf(false));
        this.setDefault("queue.dock.badge", String.valueOf(false));
        this.setDefault("queue.sleep.prevent", String.valueOf(true));
        StringBuilder options = new StringBuilder();
        options.append(5L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(150L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(200L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(500L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(1L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(2L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(5L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(15L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        this.setDefault("queue.bandwidth.options", options.toString());
        this.setDefault("queue.upload.bandwidth.bytes", String.valueOf(-1));
        this.setDefault("queue.download.bandwidth.bytes", String.valueOf(-1));
        this.setDefault("queue.connections.limit", String.valueOf(0));
        this.setDefault("queue.connections.limit.default", String.valueOf(5));
        this.setDefault(String.format("queue.connections.limit.%s", Protocol.Type.ftp.name()), String.valueOf(1));
        options = new StringBuilder();
        options.append(0).append(",");
        options.append(1).append(",");
        options.append(2).append(",");
        options.append(3).append(",");
        options.append(4).append(",");
        options.append(5).append(",");
        options.append(10).append(",");
        options.append(15).append(",");
        options.append(20).append(",");
        this.setDefault("queue.connections.options", options.toString());
        this.setDefault("queue.download.icon.update", String.valueOf(true));
        this.setDefault("queue.download.icon.threshold", String.valueOf(0x500000L));
        this.setDefault("queue.prompt.sync.action.default", TransferAction.mirror.name());
        this.setDefault("queue.prompt.download.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.upload.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.copy.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.move.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.transcript.open", String.valueOf(false));
        this.setDefault("queue.transcript.size.height", String.valueOf(200));
        this.setDefault("http.compression.enable", String.valueOf(true));
        this.setDefault("http.connections.route", String.valueOf(10));
        this.setDefault("http.connections.reuse", String.valueOf(true));
        this.setDefault("http.connections.stale.check.ms", String.valueOf(5000));
        this.setDefault("http.connections.total", String.valueOf(Integer.MAX_VALUE));
        this.setDefault("http.connections.retry", String.valueOf(1));
        this.setDefault("http.manager.timeout", String.valueOf(0));
        this.setDefault("http.socket.buffer", String.valueOf(8192));
        this.setDefault("http.credentials.charset", "UTF-8");
        this.setDefault("http.request.uri.normalize", String.valueOf(false));
        this.setDefault("ftp.datachannel.verify", String.valueOf(false));
        this.setDefault("ftp.datachannel.epsv", String.valueOf(false));
        this.setDefault("ftp.socket.buffer", String.valueOf(0));
        this.setDefault("ftp.parser.multiline.strict", String.valueOf(false));
        this.setDefault("ftp.parser.reply.strict", String.valueOf(false));
        this.setDefault("ftp.parser.mlsd.perm.enable", String.valueOf(false));
        this.setDefault("ftp.command.lista", String.valueOf(true));
        this.setDefault("ftp.command.stat", String.valueOf(true));
        this.setDefault("ftp.command.mlsd", String.valueOf(true));
        this.setDefault("ftp.connectmode.fallback", String.valueOf(false));
        this.setDefault("ftp.tls.datachannel", "P");
        this.setDefault("ftp.tls.session.requirereuse", String.valueOf(true));
        this.setDefault("ftp.ssl.session.cache.size", String.valueOf(100));
        this.setDefault("ftp.timezone.auto", String.valueOf(false));
        this.setDefault("ftp.timezone.default", TimeZone.getDefault().getID());
        this.setDefault("s3.signature.version", "AWS4HMACSHA256");
        this.setDefault("s3.location", "us-east-1");
        this.setDefault("s3.bucket.virtualhost.disable", String.valueOf(false));
        this.setDefault("s3.bucket.requesterpays", String.valueOf(true));
        this.setDefault("s3.domain", "amazonaws.com");
        this.setDefault("s3.hostname.default", "s3.amazonaws.com");
        this.setDefault("s3.endpoint.dualstack.enable", String.valueOf(true));
        this.setDefault("s3.endpoint.format.ipv4", "s3.%s.amazonaws.com");
        this.setDefault("s3.endpoint.format.ipv6", "s3.dualstack.%s.amazonaws.com");
        this.setDefault("s3.acl.default", "private");
        this.setDefault("s3.storage.class", "STANDARD");
        this.setDefault("s3.storage.class.options", "STANDARD INTELLIGENT_TIERING STANDARD_IA ONEZONE_IA REDUCED_REDUNDANCY GLACIER GLACIER_IR DEEP_ARCHIVE");
        this.setDefault("s3.encryption.algorithm", "");
        this.setDefault("s3.url.expire.seconds", String.valueOf(86400));
        this.setDefault("s3.listing.chunksize", String.valueOf(1000));
        this.setDefault("s3.listing.concurrency", String.valueOf(25));
        this.setDefault("s3.listing.metadata.enable", String.valueOf(false));
        this.setDefault("s3.upload.multipart", String.valueOf(true));
        this.setDefault("s3.upload.multipart.concurrency", String.valueOf(10));
        this.setDefault("s3.upload.multipart.partsize.minimum", String.valueOf(0x500000L));
        this.setDefault("s3.upload.multipart.threshold", String.valueOf(0x6400000L));
        this.setDefault("s3.upload.multipart.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("s3.upload.multipart.size", String.valueOf(0xA00000L));
        this.setDefault("s3.copy.multipart.size", String.valueOf(0x6400000L));
        this.setDefault("s3.upload.expect-continue", String.valueOf(true));
        this.setDefault("s3.download.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.setDefault("s3.upload.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.setDefault("s3.timestamp.enable", String.valueOf(true));
        this.setDefault("s3.accelerate.enable", String.valueOf(true));
        this.setDefault("s3.accelerate.prompt", String.valueOf(false));
        this.setDefault("s3.versioning.enable", String.valueOf(true));
        this.setDefault("s3.glacier.restore.tier", "Standard");
        this.setDefault("s3.glacier.restore.expiration.days", String.valueOf(2));
        this.setDefault("s3.lifecycle.transition.class", "GLACIER");
        this.setDefault("s3.logging.prefix", "logs/");
        this.setDefault("google.logging.prefix", "log");
        this.setDefault("cloudfront.logging.prefix", "logs/");
        this.setDefault("googlestorage.listing.chunksize", String.valueOf(1000));
        this.setDefault("googlestorage.listing.concurrency", String.valueOf(25));
        this.setDefault("googlestorage.metadata.default", "");
        this.setDefault("googlestorage.storage.class", "STANDARD");
        this.setDefault("googlestorage.storage.class.options", "STANDARD MULTI_REGIONAL REGIONAL NEARLINE COLDLINE ARCHIVE");
        this.setDefault("googlestorage.lifecycle.transition.class", "ARCHIVE");
        this.setDefault("googlestorage.acl.default", "private");
        this.setDefault("googlestorage.location", "us");
        this.setDefault("onedrive.listing.chunksize", String.valueOf(1000));
        this.setDefault("onedrive.upload.multipart.partsize.minimum", String.valueOf(327680));
        this.setDefault("onedrive.upload.multipart.partsize.factor", String.valueOf(20));
        int month = 2592000;
        this.setDefault("s3.cache.seconds", String.valueOf(2592000));
        this.setDefault("s3.metadata.default", "");
        this.setDefault("s3.lifecycle.transition.options", "1 7 10 30 60 180 360 720");
        this.setDefault("s3.lifecycle.delete.options", "1 7 10 30 60 180 360 720");
        this.setDefault("s3.delete.multiple.partition", String.valueOf(1000));
        this.setDefault("azure.metadata.default", "");
        this.setDefault("azure.listing.chunksize", String.valueOf(1000));
        this.setDefault("azure.upload.md5", String.valueOf(false));
        this.setDefault("azure.upload.snapshot", String.valueOf(false));
        this.setDefault("azure.upload.blobtype", "APPEND_BLOB");
        this.setDefault("openstack.authentication.context", "/v2.0/tokens");
        this.setDefault("openstack.metadata.default", "");
        this.setDefault("openstack.list.container.limit", String.valueOf(100));
        this.setDefault("openstack.list.object.limit", String.valueOf(10000));
        this.setDefault("openstack.account.preload", String.valueOf(true));
        this.setDefault("openstack.cdn.preload", String.valueOf(true));
        this.setDefault("openstack.container.size.preload", String.valueOf(true));
        this.setDefault("openstack.upload.largeobject", String.valueOf(true));
        this.setDefault("openstack.upload.largeobject.concurrency", String.valueOf(5));
        this.setDefault("openstack.upload.largeobject.segments.prefix", ".file-segments/");
        this.setDefault("openstack.upload.largeobject.threshold", String.valueOf(0x80000000L));
        this.setDefault("openstack.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("openstack.upload.largeobject.size", String.valueOf(1048576000L));
        this.setDefault("openstack.upload.largeobject.size.minimum", String.valueOf(0x100000L));
        this.setDefault("openstack.upload.largeobject.cleanup", String.valueOf(true));
        this.setDefault("openstack.delete.multiple.partition", String.valueOf(10000));
        this.setDefault("openstack.delete.largeobject.segments", String.valueOf(true));
        this.setDefault("googledrive.list.limit", String.valueOf(1000));
        this.setDefault("googledrive.teamdrive.enable", String.valueOf(true));
        this.setDefault("googledrive.limit.requests.second", String.valueOf(100));
        this.setDefault("googledrive.delete.multiple.partition", String.valueOf(50));
        this.setDefault("b2.bucket.acl.default", "allPrivate");
        this.setDefault("b2.listing.chunksize", String.valueOf(1000));
        this.setDefault("b2.upload.checksum.verify", String.valueOf(true));
        this.setDefault("b2.upload.largeobject", String.valueOf(true));
        this.setDefault("b2.upload.largeobject.concurrency", String.valueOf(5));
        this.setDefault("b2.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("b2.upload.largeobject.threshold", String.valueOf(0xC800000L));
        this.setDefault("b2.upload.largeobject.size", String.valueOf(0x6400000L));
        this.setDefault("b2.upload.largeobject.size.minimum", String.valueOf(0x500000L));
        this.setDefault("b2.copy.largeobject.size", String.valueOf(0x500000L));
        this.setDefault("b2.copy.largeobject.threshold", String.valueOf(0xA00000L));
        this.setDefault("b2.metadata.default", "");
        this.setDefault("sds.version.lts", "4.12");
        this.setDefault("sds.listing.chunksize", String.valueOf(500));
        this.setDefault("sds.upload.multipart.chunksize", String.valueOf(0x500000L));
        this.setDefault("sds.encryption.missingkeys.upload", String.valueOf(true));
        this.setDefault("sds.encryption.missingkeys.scheduler.period", String.valueOf(120000));
        this.setDefault("sds.encryption.missingkeys.delete.deprecated", String.valueOf(false));
        this.setDefault("sds.encryption.keys.ttl", String.valueOf(600000));
        this.setDefault("sds.useracount.ttl", String.valueOf(3600000));
        this.setDefault("sds.create.dataroom.enable", String.valueOf(true));
        this.setDefault("sds.create.dataroom.encrypt", String.valueOf(false));
        this.setDefault("sds.delete.dataroom.enable", String.valueOf(true));
        this.setDefault("sds.upload.sharelinks.keep", String.valueOf(true));
        this.setDefault("sds.upload.s3.enable", String.valueOf(true));
        this.setDefault("sds.upload.s3.status.delay", String.valueOf(50));
        this.setDefault("sds.upload.s3.status.period", String.valueOf(100));
        this.setDefault("sds.upload.s3.status.interrupt.ms", String.valueOf(30000L));
        this.setDefault("spectra.retry.delay", String.valueOf(60));
        this.setDefault("storegate.listing.chunksize", String.valueOf(500));
        this.setDefault("storegate.upload.multipart.chunksize", String.valueOf(524288.0));
        this.setDefault("storegate.lock.ttl", String.valueOf(86400000));
        this.setDefault("storegate.login.hint", "");
        this.setDefault("ctera.attach.devicetype", "DriveConnect");
        this.setDefault("oauth.browser.open.warn", String.valueOf(false));
        this.setDefault("brick.pairing.nickname.configure", String.valueOf(false));
        this.setDefault("brick.pairing.hostname.configure", String.valueOf(true));
        this.setDefault("brick.pairing.interval.ms", String.valueOf(1000L));
        this.setDefault("brick.pairing.interrupt.ms", String.valueOf(600000L));
        this.setDefault("brick.migration.interval.ms", String.valueOf(500L));
        this.setDefault("brick.migration.interrupt.ms", String.valueOf(10000L));
        this.setDefault("brick.listing.chunksize", String.valueOf(1000));
        this.setDefault("brick.upload.multipart.size", String.valueOf(0xA00000L));
        this.setDefault("brick.upload.multipart.concurrency", String.valueOf(10));
        this.setDefault("dropbox.upload.chunksize", String.valueOf(0x9600000L));
        this.setDefault("dropbox.business.enable", String.valueOf(true));
        this.setDefault("dropbox.delete.poll.interval.ms", String.valueOf(500L));
        this.setDefault("webdav.ntlm.domain", "");
        this.setDefault("webdav.ntlm.workstation", "");
        this.setDefault("webdav.ntlm.windows.authentication.enable", String.valueOf(false));
        this.setDefault("webdav.basic.preemptive", String.valueOf(true));
        this.setDefault("webdav.expect-continue", String.valueOf(true));
        this.setDefault("webdav.redirect.GET.follow", String.valueOf(true));
        this.setDefault("webdav.redirect.HEAD.follow", String.valueOf(true));
        this.setDefault("webdav.redirect.PUT.follow", String.valueOf(false));
        this.setDefault("webdav.redirect.PROPFIND.follow", String.valueOf(true));
        this.setDefault("webdav.metadata.default", "");
        this.setDefault("webdav.microsoftiis.header.translate", String.valueOf(true));
        this.setDefault("webdav.list.handler.sax", String.valueOf(true));
        this.setDefault("webdav.lock.enable", String.valueOf(true));
        this.setDefault("connection.pool.minidle", String.valueOf(1));
        this.setDefault("connection.pool.maxidle", String.valueOf(5));
        this.setDefault("connection.pool.maxtotal", String.valueOf(Integer.MAX_VALUE));
        this.setDefault("connection.login.name", "");
        this.setDefault("connection.login.anon.name", "anonymous");
        this.setDefault("connection.login.anon.pass", "cyberduck@example.net");
        this.setDefault("connection.login.keychain", String.valueOf(true));
        this.setDefault("vault.keychain", String.valueOf(false));
        this.setDefault("connection.port.default", String.valueOf(21));
        this.setDefault("connection.protocol.default", Scheme.ftp.name());
        this.setDefault("connection.socket.keepalive", String.valueOf(true));
        this.setDefault("connection.socket.linger", String.valueOf(false));
        this.setDefault("connection.timeout.seconds", String.valueOf(30));
        this.setDefault("connection.retry", String.valueOf(1));
        this.setDefault("connection.retry.max", String.valueOf(20));
        this.setDefault("connection.retry.delay", String.valueOf(0));
        this.setDefault("connection.retry.backoff.enable", String.valueOf(false));
        this.setDefault("transfer.connection.retry", String.valueOf(1));
        this.setDefault("transfer.connection.retry.delay", String.valueOf(0));
        this.setDefault("connection.hostname.default", "");
        this.setDefault("connection.hostname.idn", String.valueOf(true));
        this.setDefault("connection.dns.ipv6", String.valueOf(false));
        if (this.getBoolean("connection.dns.ipv6")) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(true));
        }
        this.setDefault("connection.proxy.enable", String.valueOf(true));
        this.setDefault("connection.proxy.ntlm.domain", "");
        this.setDefault("connection.proxy.windows.authentication.enable", String.valueOf(false));
        this.setDefault(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.ftp}), String.valueOf(true));
        this.setDefault(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.http}), String.valueOf(true));
        this.setDefault("connection.ssl.provider.bouncycastle.position", String.valueOf(1));
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", String.valueOf(true));
        int position = this.getInteger("connection.ssl.provider.bouncycastle.position");
        BouncyCastleProvider provider = new BouncyCastleProvider();
        provider.put((Object)"Alg.Alias.SecretKeyFactory.PBE", (Object)"PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        if (log.isInfoEnabled()) {
            log.info(String.format("Install provider %s at position %d", provider, position));
        }
        Security.insertProviderAt((Provider)provider, position);
        this.setDefault("connection.ssl.protocols", "TLSv1.3,TLSv1.2,TLSv1.1,TLSv1");
        this.setDefault("connection.ssl.protocols.ftp", "TLSv1.2,TLSv1.1,TLSv1");
        this.setDefault("connection.ssl.cipher.blacklist", "");
        this.setDefault("connection.ssl.x509.revocation.online", String.valueOf(false));
        this.setDefault("connection.ssl.keystore.type", null);
        this.setDefault("connection.ssl.keystore.provider", null);
        this.setDefault("connection.ssl.securerandom.algorithm", "NativePRNG");
        this.setDefault("connection.ssl.securerandom.provider", "SUN");
        System.setProperty("jdk.tls.useExtendedMasterSecret", String.valueOf(false));
        System.setProperty("jdk.tls.client.enableSessionTicketExtension", String.valueOf(false));
        this.setDefault("connection.chunksize", String.valueOf(32768));
        this.setDefault("connection.buffer", String.valueOf(8192));
        this.setDefault("connection.buffer.send", String.valueOf(0));
        this.setDefault("connection.buffer.receive", String.valueOf(0));
        this.setDefault("disk.unmount.timeout", String.valueOf(2));
        this.setDefault("bookmark.favicon.download", String.valueOf(true));
        this.setDefault("bookmark.icon.size", String.valueOf(64));
        this.setDefault("bookmark.menu.icon.size", String.valueOf(64));
        this.setDefault("ssh.knownhosts", "~/.ssh/known_hosts");
        this.setDefault("ssh.knownhosts.hostname.hash", String.valueOf(false));
        this.setDefault("ssh.knownhosts.bookmark", "");
        this.setDefault("ssh.authentication.publickey.default.enable", String.valueOf(false));
        this.setDefault("ssh.authentication.publickey.default.rsa", "~/.ssh/id_rsa");
        this.setDefault("ssh.authentication.publickey.default.dsa", "~/.ssh/id_dsa");
        this.setDefault("ssh.authentication.agent.enable", String.valueOf(true));
        this.setDefault("ssh.heartbeat.provider", "keep-alive");
        this.setDefault("ssh.heartbeat.seconds", String.valueOf(60));
        this.setDefault("ssh.compression", "zlib");
        this.setDefault("ssh.algorithm.cipher.blacklist", "");
        this.setDefault("ssh.algorithm.mac.blacklist", "");
        this.setDefault("ssh.algorithm.kex.blacklist", "");
        this.setDefault("ssh.algorithm.signature.blacklist", "");
        this.setDefault("sftp.read.maxunconfirmed", String.valueOf(64));
        this.setDefault("sftp.write.maxunconfirmed", String.valueOf(64));
        this.setDefault("sftp.write.chunksize", String.valueOf(32768));
        this.setDefault("sftp.permissions.server.blacklist", "OpenSSH_for_Windows");
        this.setDefault("archive.default", "tar.gz");
        this.setDefault("archive.command.create.tar", "cd {2}; tar -cpPf {0}.tar {1}");
        this.setDefault("archive.command.create.tar.gz", "cd {2}; tar -czpPf {0}.tar.gz {1}");
        this.setDefault("archive.command.create.tar.bz2", "cd {2}; tar -cjpPf {0}.tar.bz2 {1}");
        this.setDefault("archive.command.create.zip", "cd {2}; zip -qr {0}.zip {1}");
        this.setDefault("archive.command.create.gz", "gzip -qr {1}");
        this.setDefault("archive.command.create.bz2", "bzip2 -zk {1}");
        this.setDefault("archive.command.expand.tar", "tar -xpPf {0} -C {1}");
        this.setDefault("archive.command.expand.tar.gz", "tar -xzpPf {0} -C {1}");
        this.setDefault("archive.command.expand.tar.bz2", "tar -xjpPf {0} -C {1}");
        this.setDefault("archive.command.expand.zip", "unzip -qn {0} -d {1}");
        this.setDefault("archive.command.expand.gz", "gzip -d {0}");
        this.setDefault("archive.command.expand.bz2", "bzip2 -dk {0}");
        this.setDefault("update.feed", "release");
        this.setDefault("update.feed.nightly.enable", String.valueOf(true));
        this.setDefault("update.feed.beta.enable", String.valueOf(true));
        this.setDefault("update.check", String.valueOf(true));
        int day = 86400;
        this.setDefault("update.check.interval", String.valueOf(86400));
        this.setDefault("update.check.timestamp", String.valueOf(0));
        this.setDefault("terminal.bundle.identifier", "com.apple.Terminal");
        this.setDefault("terminal.command.ssh", "ssh -t {0} {1}@{2} -p {3} \"cd {4} && exec \\$SHELL -l\"");
        this.setDefault("threading.pool.size.max", String.valueOf(20));
        this.setDefault("threading.pool.keepalive.seconds", String.valueOf(60L));
        this.setDefault("cryptomator.enable", String.valueOf(true));
        this.setDefault("cryptomator.vault.version", String.valueOf(8));
        this.setDefault("cryptomator.vault.autodetect", String.valueOf(true));
        this.setDefault("cryptomator.vault.masterkey.filename", "masterkey.cryptomator");
        this.setDefault("cryptomator.vault.config.filename", "vault.cryptomator");
        this.setDefault("cryptomator.vault.pepper", "");
        this.setDefault("cryptomator.cache.size", String.valueOf(1000));
        this.setDefault("eue.upload.multipart.size", String.valueOf(0x400000L));
        this.setDefault("eue.upload.multipart.threshold", String.valueOf(0x400000L));
        this.setDefault("eue.upload.multipart.concurrency", String.valueOf(10));
        this.setDefault("eue.listing.chunksize", String.valueOf(100));
        this.setDefault("eue.share.expiration.millis", String.valueOf(31540000000L));
        this.setDefault("eue.share.deletable", String.valueOf(false));
        this.setDefault("eue.share.writable", String.valueOf(false));
        this.setDefault("eue.share.readable", String.valueOf(true));
        this.setDefault("eue.share.notification.enable", String.valueOf(false));
        this.setDefault("eue.limit.hint.second", String.valueOf(2));
        this.setDefault("eue.limit.requests.second", String.valueOf(3));
        this.setDefault("eue.shares.ttl", String.valueOf(600000));
        this.setDefault("eue.delete.multiple.partition", String.valueOf(100));
        this.setDefault("box.upload.multipart.threshold", String.valueOf(0x1400000));
        this.setDefault("box.upload.multipart.concurrency", String.valueOf(10));
        this.setDefault("box.listing.chunksize", String.valueOf(100));
        this.setDefault("preferences.general.enable", String.valueOf(true));
        this.setDefault("preferences.browser.enable", String.valueOf(true));
        this.setDefault("preferences.queue.enable", String.valueOf(true));
        this.setDefault("preferences.s3.enable", String.valueOf(true));
        this.setDefault("preferences.googlestorage.enable", String.valueOf(true));
        this.setDefault("preferences.sftp.enable", String.valueOf(true));
        this.setDefault("preferences.ftp.enable", String.valueOf(true));
        this.setDefault("preferences.profiles.enable", String.valueOf(true));
        this.setDefault("preferences.editor.enable", String.valueOf(true));
        this.setDefault("preferences.connection.enable", String.valueOf(true));
        this.setDefault("preferences.bandwidth.enable", String.valueOf(true));
        this.setDefault("preferences.language.enable", String.valueOf(true));
        this.setDefault("preferences.update.enable", String.valueOf(true));
        this.setDefault("preferences.cryptomator.enable", String.valueOf(true));
        this.setDefault("info.general.enable", String.valueOf(true));
        this.setDefault("info.permissions.enable", String.valueOf(true));
        this.setDefault("info.acl.enable", String.valueOf(true));
        this.setDefault("info.distribution.enable", String.valueOf(true));
        this.setDefault("info.s3.enable", String.valueOf(true));
        this.setDefault("info.metadata.enable", String.valueOf(true));
        this.setDefault("info.versions.enable", String.valueOf(true));
    }

    public void setLogging(String level) {
        this.setProperty("logging", level);
        this.configureLogging(level);
    }

    protected void configureLogging(String level) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String file = this.getDefault("logging.config");
        URL configuration = null == file ? Preferences.class.getClassLoader().getResource("log4j.xml") : Preferences.class.getClassLoader().getResource(file);
        LoggerContext context = Configurator.initialize((Configuration)new DefaultConfiguration());
        if (null != configuration) {
            try {
                context.initialize();
                Configurator.initialize(null, (ConfigurationSource)new ConfigurationSource(configuration.openStream()));
            }
            catch (IOException e) {
                log.error(String.format("Unable to load log4j configuration from %s", configuration.toExternalForm()));
            }
        }
        Configurator.setRootLevel((Level)Level.toLevel((String)level, (Level)Level.ERROR));
        ImmutableMap map = new ImmutableMap.Builder().put((Object)Level.ALL, (Object)java.util.logging.Level.ALL).put((Object)Level.DEBUG, (Object)java.util.logging.Level.FINE).put((Object)Level.ERROR, (Object)java.util.logging.Level.SEVERE).put((Object)Level.FATAL, (Object)java.util.logging.Level.SEVERE).put((Object)Level.INFO, (Object)java.util.logging.Level.INFO).put((Object)Level.OFF, (Object)java.util.logging.Level.OFF).put((Object)Level.TRACE, (Object)java.util.logging.Level.FINEST).put((Object)Level.WARN, (Object)java.util.logging.Level.WARNING).build();
        Logger.getLogger("").setLevel((java.util.logging.Level)map.get((Object)LogManager.getRootLogger().getLevel()));
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        Collection loggerConfigs = logContext.getConfiguration().getLoggers().values();
        for (LoggerConfig loggerConfig : loggerConfigs) {
            if (loggerConfig.getLevel() == null) continue;
            Logger.getLogger(loggerConfig.getName()).setLevel((java.util.logging.Level)map.get((Object)loggerConfig.getLevel()));
        }
        this.configureAppenders(level);
    }

    protected void configureAppenders(String level) {
        String logfolder = LogDirectoryFinderFactory.get().find().getAbsolute();
        String appname = StringUtils.replaceChars((String)StringUtils.lowerCase((String)this.getProperty("application.name")), (String)LIST_SEPERATOR, (String)"");
        Local active = LocalFactory.get(logfolder, String.format("%s.log", appname));
        Local archives = LocalFactory.get(logfolder, String.format("%s-%%i.log.zip", appname));
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(RollingFileAppender.class.getName())).withFileName(active.getAbsolute()).withFilePattern(archives.getAbsolute()).withPolicy((TriggeringPolicy)(Level.DEBUG.toString().equals(level) ? SizeBasedTriggeringPolicy.createPolicy((String)"100MB") : SizeBasedTriggeringPolicy.createPolicy((String)"10MB"))).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMin("1").withMax("5").withCompressionLevelStr(String.valueOf(9)).build()).setLayout((Layout)PatternLayout.newBuilder().withConfiguration(config).withPattern("%d [%t] %-5p %c - %m%n").withCharset(StandardCharsets.UTF_8).build())).build();
        appender.start();
        config.addAppender((Appender)appender);
        config.getRootLogger().addAppender((Appender)appender, null, null);
        ctx.updateLoggers();
    }

    @Override
    public List<String> getList(String property) {
        String value = this.getProperty(property);
        return PreferencesReader.toList(value);
    }

    @Override
    public int getInteger(String key) {
        String v = this.getProperty(key);
        return PreferencesReader.toInteger(v);
    }

    @Override
    public float getFloat(String key) {
        String v = this.getProperty(key);
        return PreferencesReader.toFloat(v);
    }

    @Override
    public long getLong(String key) {
        String v = this.getProperty(key);
        return PreferencesReader.toLong(v);
    }

    @Override
    public double getDouble(String key) {
        String v = this.getProperty(key);
        return PreferencesReader.toDouble(v);
    }

    @Override
    public boolean getBoolean(String key) {
        String v = this.getProperty(key);
        return PreferencesReader.toBoolean(v);
    }

    protected void setFactories() {
        this.setDefault("factory.serializer.class", PlistSerializer.class.getName());
        this.setDefault("factory.deserializer.class", PlistDeserializer.class.getName());
        this.setDefault("factory.reader.profile.class", ProfilePlistReader.class.getName());
        this.setDefault("factory.writer.profile.class", PlistWriter.class.getName());
        this.setDefault("factory.reader.transfer.class", TransferPlistReader.class.getName());
        this.setDefault("factory.writer.transfer.class", PlistWriter.class.getName());
        this.setDefault("factory.reader.host.class", HostPlistReader.class.getName());
        this.setDefault("factory.writer.host.class", PlistWriter.class.getName());
        this.setDefault("factory.locale.class", DisabledLocale.class.getName());
        this.setDefault("factory.local.class", Local.class.getName());
        this.setDefault("factory.certificatestore.class", DisabledCertificateStore.class.getName());
        this.setDefault("factory.logincallback.class", DisabledLoginCallback.class.getName());
        this.setDefault("factory.passwordcallback.class", DisabledPasswordCallback.class.getName());
        this.setDefault("factory.certificatetrustcallback.class", DisabledCertificateTrustCallback.class.getName());
        this.setDefault("factory.certificateidentitycallback.class", DisabledCertificateIdentityCallback.class.getName());
        this.setDefault("factory.alertcallback.class", DisabledAlertCallback.class.getName());
        this.setDefault("factory.hostkeycallback.class", DisabledHostKeyCallback.class.getName());
        this.setDefault("factory.transfererrorcallback.class", DisabledTransferErrorCallback.class.getName());
        this.setDefault("factory.temporaryfiles.class", DefaultTemporaryFileService.class.getName());
        this.setDefault("factory.touch.class", DefaultLocalTouchFeature.class.getName());
        this.setDefault("factory.autorelease.class", DisabledActionOperationBatcher.class.getName());
        this.setDefault("factory.schemehandler.class", DisabledSchemeHandler.class.getName());
        this.setDefault("factory.iconservice.class", DisabledIconService.class.getName());
        this.setDefault("factory.iconcache.class", DisabledIconCache.class.getName());
        this.setDefault("factory.notification.class", DisabledNotificationService.class.getName());
        this.setDefault("factory.notification.filter.class", DisabledNotificationFilterService.class.getName());
        this.setDefault("factory.sleeppreventer.class", DisabledSleepPreventer.class.getName());
        this.setDefault("factory.quarantine.class", DisabledQuarantineService.class.getName());
        for (Transfer.Type t : Transfer.Type.values()) {
            this.setDefault(String.format("factory.transferpromptcallback.%s.class", t.name()), DisabledTransferPrompt.class.getName());
        }
        this.setDefault("factory.supportdirectoryfinder.class", TemporarySupportDirectoryFinder.class.getName());
        this.setDefault("factory.logdirectoryfinder.class", SupportDirectoryLogDirectoryFinder.class.getName());
        this.setDefault("factory.localsupportdirectoryfinder.class", TemporarySupportDirectoryFinder.class.getName());
        this.setDefault("factory.applicationresourcesfinder.class", TemporaryApplicationResourcesFinder.class.getName());
        this.setDefault("factory.applicationloginregistry.class", DisabledApplicationLoginRegistry.class.getName());
        this.setDefault("factory.workingdirectory.class", DefaultWorkingDirectoryFinder.class.getName());
        this.setDefault("factory.bookmarkresolver.class", DisabledFilesystemBookmarkResolver.class.getName());
        this.setDefault("factory.watchservice.class", NIOEventWatchService.class.getName());
        this.setDefault("factory.proxy.class", DisabledProxyFinder.class.getName());
        this.setDefault("factory.passwordstore.class", DisabledPasswordStore.class.getName());
        this.setDefault("factory.proxycredentialsstore.class", PreferencesProxyCredentialsStore.class.getName());
        this.setDefault("factory.dateformatter.class", DefaultUserDateFormatter.class.getName());
        this.setDefault("factory.trash.class", NativeLocalTrashFeature.class.getName());
        this.setDefault("factory.symlink.class", NullLocalSymlinkFeature.class.getName());
        this.setDefault("factory.licensefactory.class", DonationKeyFactory.class.getName());
        this.setDefault("factory.badgelabeler.class", DisabledApplicationBadgeLabeler.class.getName());
        this.setDefault("factory.filedescriptor.class", NullFileDescriptor.class.getName());
        this.setDefault("factory.terminalservice.class", DisabledTerminalService.class.getName());
        this.setDefault("factory.applicationfinder.class", DisabledApplicationFinder.class.getName());
        this.setDefault("factory.applicationlauncher.class", DisabledApplicationLauncher.class.getName());
        this.setDefault("factory.browserlauncher.class", DisabledBrowserLauncher.class.getName());
        this.setDefault("factory.reachability.class", DisabledReachability.class.getName());
        this.setDefault("factory.updater.class", DisabledPeriodicUpdater.class.getName());
        this.setDefault("factory.updater.arguments.class", DisabledUpdateCheckerArguments.class.getName());
        this.setDefault("factory.threadpool.class", DefaultThreadPool.class.getName());
        this.setDefault("factory.urlfilewriter.class", InternetShortcutFileWriter.class.getName());
        this.setDefault("factory.vault.class", DisabledVault.class.getName());
        this.setDefault("factory.securerandom.class", DefaultSecureRandomProvider.class.getName());
        this.setDefault("factory.providerhelpservice.class", DefaultProviderHelpService.class.getName());
        this.setDefault("factory.quicklook.class", ApplicationLauncherQuicklook.class.getName());
        this.setDefault("factory.connectiontimeout.class", DefaultConnectionTimeout.class.getName());
    }

    public abstract void save();

    public abstract void load();

    public String locale() {
        return this.applicationLocales().iterator().next();
    }

    @Override
    public abstract List<String> applicationLocales();

    @Override
    public abstract List<String> systemLocales();

    public String getDisplayName(String locale) {
        Locale l = StringUtils.contains((CharSequence)locale, (CharSequence)"_") ? new Locale(locale.split("_")[0], locale.split("_")[1]) : new Locale(locale);
        return StringUtils.capitalize((String)l.getDisplayName(l));
    }

    public static final class Version {
        private final Package pkg;

        public Version() {
            this(Version.class.getPackage());
        }

        public Version(Package pkg) {
            this.pkg = pkg;
        }

        public String getSpecification() {
            return this.pkg == null ? null : this.pkg.getSpecificationVersion();
        }

        public String getImplementation() {
            return this.pkg == null ? null : this.pkg.getImplementationVersion();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Version{");
            sb.append("version='").append(this.getSpecification()).append('\'');
            sb.append(", hash='").append(this.getImplementation()).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

