/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.StatelessSessionPool;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatefulSessionPool
extends StatelessSessionPool {
    private static final Logger log = LogManager.getLogger(StatefulSessionPool.class);
    private final FailureDiagnostics<BackgroundException> diagnostics = new DefaultFailureDiagnostics();
    private final Lock lock = new ReentrantLock();
    private final ConnectionService connect;
    private final Session<?> session;

    public StatefulSessionPool(ConnectionService connect, Session<?> session, TranscriptListener transcript, VaultRegistry registry) {
        super(connect, session, transcript, registry);
        this.connect = connect;
        this.session = session;
    }

    @Override
    public Session<?> borrow(BackgroundActionState callback) throws BackgroundException {
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Acquire lock for connection %s", this.session));
            }
            this.lock.lock();
        }
        catch (IllegalMonitorStateException e) {
            log.warn(String.format("Failure acquiring lock for %s", this.session));
            throw new ConnectionCanceledException(e);
        }
        return super.borrow(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Session<?> conn, BackgroundException failure) {
        block10: {
            try {
                if (this.diagnostics.determine(failure) != FailureDiagnostics.Type.network) break block10;
                log.warn(String.format("Close session %s after failure %s", this.session, failure));
                try {
                    this.connect.close(conn);
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s closing connection", e.getMessage()));
                }
            }
            catch (Throwable throwable) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Release lock for connection %s", this.session));
                    }
                    this.lock.unlock();
                }
                catch (IllegalMonitorStateException ignored) {
                    log.warn(String.format("Failure releasing lock for %s", this.session));
                }
                throw throwable;
            }
        }
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Release lock for connection %s", this.session));
            }
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn(String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public void evict() {
        super.evict();
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn(String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn(String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StatefulSessionPool{");
        sb.append("lock=").append(this.lock);
        sb.append(", session=").append(this.session);
        sb.append('}');
        return sb.toString();
    }
}

