/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.vault.VaultRegistry;

public interface SessionPool {
    public static final SessionPool DISCONNECTED = new DisconnectedSessionPool();

    public Session<?> borrow(BackgroundActionState var1) throws BackgroundException;

    public void release(Session<?> var1, BackgroundException var2);

    public void evict();

    public Host getHost();

    public VaultRegistry getVault();

    public Session.State getState();

    public <T> T getFeature(Class<T> var1);

    public void shutdown();

    public static final class DisconnectedSessionPool
    implements SessionPool {
        private static final Host DISCONNECTED = new Host(new DisabledProtocol());

        @Override
        public Session<?> borrow(BackgroundActionState callback) {
            return null;
        }

        @Override
        public void release(Session<?> session, BackgroundException failure) {
        }

        @Override
        public void evict() {
        }

        @Override
        public Host getHost() {
            return DISCONNECTED;
        }

        @Override
        public VaultRegistry getVault() {
            return VaultRegistry.DISABLED;
        }

        @Override
        public Session.State getState() {
            return Session.State.closed;
        }

        @Override
        public <T> T getFeature(Class<T> type) {
            return null;
        }

        @Override
        public void shutdown() {
        }

        private static class DisabledProtocol
        extends AbstractProtocol {
            private DisabledProtocol() {
            }

            @Override
            public String getName() {
                return "";
            }

            @Override
            public String getIdentifier() {
                return "";
            }

            @Override
            public String getDescription() {
                return "";
            }

            @Override
            public Scheme getScheme() {
                return Scheme.file;
            }
        }
    }

    public static final class SingleSessionPool
    implements SessionPool {
        private final Session<?> session;

        public SingleSessionPool(Session<?> session) {
            this.session = session;
        }

        public SingleSessionPool(Session<?> session, VaultRegistry registry) {
            this.session = session;
        }

        @Override
        public Session<?> borrow(BackgroundActionState callback) {
            return this.session;
        }

        @Override
        public void release(Session<?> session, BackgroundException failure) {
        }

        @Override
        public void evict() {
        }

        @Override
        public Host getHost() {
            return this.session.getHost();
        }

        @Override
        public VaultRegistry getVault() {
            return VaultRegistry.DISABLED;
        }

        @Override
        public Session.State getState() {
            return Session.State.open;
        }

        @Override
        public <T> T getFeature(Class<T> type) {
            return this.session.getFeature(type);
        }

        @Override
        public void shutdown() {
        }
    }

    public static interface Callback {
        public boolean isCanceled();
    }
}

