/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.vault.VaultRegistry;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PooledSessionFactory
extends BasePooledObjectFactory<Session> {
    private static final Logger log = LogManager.getLogger(PooledSessionFactory.class);
    private final ConnectionService connect;
    private final X509TrustManager trust;
    private final X509KeyManager key;
    private final Host bookmark;
    private final VaultRegistry registry;

    public PooledSessionFactory(ConnectionService connect, X509TrustManager trust, X509KeyManager key, Host bookmark, VaultRegistry registry) {
        this.connect = connect;
        this.trust = trust;
        this.key = key;
        this.bookmark = bookmark;
        this.registry = registry;
    }

    public Session create() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create new session for host %s in pool", this.bookmark));
        }
        return SessionFactory.create(this.bookmark, this.trust, this.key).withRegistry(this.registry);
    }

    public PooledObject<Session> wrap(Session session) {
        return new DefaultPooledObject((Object)session);
    }

    public void activateObject(PooledObject<Session> p) throws BackgroundException {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Activate session %s", session));
        }
        this.connect.check(session, new DisabledCancelCallback());
    }

    public void passivateObject(PooledObject<Session> p) {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Pause session %s", session));
        }
    }

    public void destroyObject(PooledObject<Session> p) throws BackgroundException {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Destroy session %s", session));
        }
        this.connect.close(session);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PooledSessionFactory{");
        sb.append("bookmark=").append(this.bookmark);
        sb.append('}');
        return sb.toString();
    }
}

