/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.PooledSessionFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.pool.StatelessSessionPool;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.time.Duration;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSessionPool
implements SessionPool {
    private static final Logger log = LogManager.getLogger(DefaultSessionPool.class);
    private static final long BORROW_MAX_WAIT_INTERVAL = 1000L;
    private static final int POOL_WARNING_THRESHOLD = 5;
    private final FailureDiagnostics<BackgroundException> diagnostics = new DefaultFailureDiagnostics();
    private final ConnectionService connect;
    private final TranscriptListener transcript;
    private final Host bookmark;
    private final VaultRegistry registry;
    private final GenericObjectPool<Session> pool;
    private SessionPool features = SessionPool.DISCONNECTED;

    public DefaultSessionPool(ConnectionService connect, X509TrustManager trust, X509KeyManager key, VaultRegistry registry, TranscriptListener transcript, Host bookmark) {
        this.connect = connect;
        this.registry = registry;
        this.bookmark = bookmark;
        this.transcript = transcript;
        GenericObjectPoolConfig configuration = new GenericObjectPoolConfig();
        configuration.setJmxEnabled(false);
        configuration.setEvictionPolicyClassName(CustomPoolEvictionPolicy.class.getName());
        configuration.setBlockWhenExhausted(true);
        configuration.setMaxWait(Duration.ofMillis(1000L));
        this.pool = new GenericObjectPool((PooledObjectFactory)new PooledSessionFactory(connect, trust, key, bookmark, registry), configuration);
        AbandonedConfig abandon = new AbandonedConfig();
        abandon.setUseUsageTracking(true);
        this.pool.setAbandonedConfig(abandon);
    }

    public DefaultSessionPool(ConnectionService connect, VaultRegistry registry, TranscriptListener transcript, Host bookmark, GenericObjectPool<Session> pool) {
        this.connect = connect;
        this.transcript = transcript;
        this.bookmark = bookmark;
        this.registry = registry;
        this.pool = pool;
    }

    public DefaultSessionPool withMinIdle(int count) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Configure with min idle %d", count));
        }
        this.pool.setMinIdle(count);
        return this;
    }

    public DefaultSessionPool withMaxIdle(int count) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Configure with max idle %d", count));
        }
        this.pool.setMaxIdle(count);
        return this;
    }

    public DefaultSessionPool withMaxTotal(int count) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Configure with max total %d", count));
        }
        this.pool.setMaxTotal(count);
        return this;
    }

    @Override
    public Session<?> borrow(BackgroundActionState callback) throws BackgroundException {
        int numActive = this.pool.getNumActive();
        if (numActive > 5) {
            log.warn(String.format("Possibly large number of open connections (%d) in pool %s", numActive, this));
        }
        try {
            while (!callback.isCanceled()) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Borrow session from pool %s", this));
                    }
                    Session session = (Session)this.pool.borrowObject();
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Borrowed session %s from pool %s", session, this));
                    }
                    if (DISCONNECTED == this.features) {
                        this.features = new StatelessSessionPool(this.connect, session, this.transcript, this.registry);
                    }
                    return session.withListener(this.transcript);
                }
                catch (IllegalStateException e) {
                    throw new ConnectionCanceledException(e);
                }
                catch (NoSuchElementException e) {
                    if (this.pool.isClosed()) {
                        throw new ConnectionCanceledException(e);
                    }
                    Throwable cause = e.getCause();
                    if (null == cause) {
                        log.warn(String.format("Timeout borrowing session from pool %s. Wait for another %dms", this, 1000L));
                        continue;
                    }
                    if (cause instanceof BackgroundException) {
                        BackgroundException failure = (BackgroundException)cause;
                        log.warn(String.format("Failure %s obtaining connection for %s", failure, this));
                        if (this.diagnostics.determine(failure) == FailureDiagnostics.Type.network) {
                            int max = Math.max(1, this.pool.getMaxIdle() - 1);
                            log.warn(String.format("Lower maximum idle pool size to %d connections.", max));
                            this.pool.setMaxIdle(max);
                            this.pool.clear();
                        }
                        throw failure;
                    }
                    log.error(String.format("Borrowing session from pool %s failed with %s", this, e));
                    throw new DefaultExceptionMappingService().map(cause);
                }
            }
            throw new ConnectionCanceledException();
        }
        catch (BackgroundException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof BackgroundException) {
                throw (BackgroundException)e.getCause();
            }
            throw new BackgroundException(e.getMessage(), e);
        }
    }

    @Override
    public void release(Session<?> session, BackgroundException failure) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Release session %s to pool", session));
        }
        try {
            if (this.diagnostics.determine(failure) == FailureDiagnostics.Type.network) {
                log.warn(String.format("Invalidate session %s in pool after failure %s", session, failure));
                try {
                    this.pool.invalidateObject(session.removeListener(this.transcript));
                }
                catch (Exception e) {
                    log.warn(String.format("Failure invalidating session %s in pool. %s", session, e.getMessage()));
                }
            } else {
                this.pool.returnObject(session);
            }
        }
        catch (IllegalStateException e) {
            log.warn(String.format("Failed to release session %s. %s", session, e.getMessage()));
        }
    }

    @Override
    public void evict() {
        if (log.isInfoEnabled()) {
            log.info(String.format("Clear idle connections in pool %s", this));
        }
        this.pool.clear();
    }

    @Override
    public void shutdown() {
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Close connection pool %s", this));
            }
            this.evict();
            this.pool.close();
        }
        catch (Exception e) {
            log.warn(String.format("Failure closing connection pool %s", e.getMessage()));
        }
        finally {
            this.registry.clear();
        }
    }

    @Override
    public Host getHost() {
        return this.bookmark;
    }

    @Override
    public VaultRegistry getVault() {
        return this.registry;
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public Session.State getState() {
        if (this.pool.isClosed()) {
            return Session.State.closed;
        }
        if (0 == this.pool.getNumIdle()) {
            return Session.State.opening;
        }
        return Session.State.open;
    }

    @Override
    public <T> T getFeature(Class<T> type) {
        if (DISCONNECTED == this.features) {
            return SessionFactory.create(this.bookmark, new DisabledX509TrustManager(), new DefaultX509KeyManager()).getFeature(type);
        }
        return this.features.getFeature(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultSessionPool{");
        sb.append("bookmark=").append(this.bookmark);
        sb.append(", idle=").append(this.pool.getNumIdle());
        sb.append(", active=").append(this.pool.getNumActive());
        sb.append(", waiters=").append(this.pool.getNumWaiters());
        sb.append('}');
        return sb.toString();
    }

    public static final class CustomPoolEvictionPolicy
    implements EvictionPolicy<Session<?>> {
        public boolean evict(EvictionConfig config, PooledObject<Session<?>> underTest, int idleCount) {
            log.warn(String.format("Evict idle session %s from pool", underTest));
            return true;
        }
    }
}

