/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import ch.cyberduck.core.io.watchservice.WatchServiceFactory;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileWatcher {
    private static final Logger log = LogManager.getLogger(FileWatcher.class);
    private final RegisterWatchService monitor;
    private final ThreadPool pool;

    public FileWatcher() {
        this(WatchServiceFactory.get());
    }

    public FileWatcher(RegisterWatchService monitor) {
        this.monitor = monitor;
        this.pool = new DefaultThreadPool("watcher", 1);
    }

    public CountDownLatch register(final Local folder, final Filter<Local> filter, final FileWatcherListener listener) throws IOException {
        WatchKey key;
        Path canonical = new File(folder.getAbsolute()).getCanonicalFile().toPath();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Register folder %s watching with filter %s", canonical, filter));
        }
        if (!(key = this.monitor.register(canonical, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, new WatchEvent.Modifier[0])).isValid()) {
            throw new IOException(String.format("Failure registering for events in %s", canonical));
        }
        final CountDownLatch lock = new CountDownLatch(1);
        this.pool.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                WatchKey key;
                boolean valid;
                do {
                    try {
                        lock.countDown();
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Wait for key from watch service %s", FileWatcher.this.monitor));
                        }
                        key = FileWatcher.this.monitor.take();
                    }
                    catch (ClosedWatchServiceException e) {
                        return true;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Retrieved key %s from watch service %s", key, FileWatcher.this.monitor));
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Detected file system event %s", kind.name()));
                        }
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            log.error(String.format("Overflow event for %s", folder));
                            continue;
                        }
                        if (filter.accept(FileWatcher.normalize(folder, event.context().toString()))) {
                            FileWatcher.this.callback(folder, event, listener);
                            continue;
                        }
                        log.warn(String.format("Ignored file system event for unknown file %s", event.context()));
                    }
                } while (valid = key.reset());
                return true;
            }
        });
        return lock;
    }

    private static Local normalize(Local parent, String name) {
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)String.valueOf(parent.getDelimiter()))) {
            return LocalFactory.get(name);
        }
        return LocalFactory.get(parent, name);
    }

    private void callback(Local folder, WatchEvent<?> event, FileWatcherListener l) {
        WatchEvent.Kind<?> kind = event.kind();
        if (log.isInfoEnabled()) {
            log.info(String.format("Process file system event %s for %s", kind.name(), event.context()));
        }
        if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
            l.fileWritten(FileWatcher.normalize(folder, event.context().toString()));
        } else if (StandardWatchEventKinds.ENTRY_DELETE == kind) {
            l.fileDeleted(FileWatcher.normalize(folder, event.context().toString()));
        } else if (StandardWatchEventKinds.ENTRY_CREATE == kind) {
            l.fileCreated(FileWatcher.normalize(folder, event.context().toString()));
        } else {
            log.debug(String.format("Ignored file system event %s for %s", kind.name(), event.context()));
        }
    }

    public void close() {
        try {
            this.monitor.close();
            this.pool.shutdown(false);
        }
        catch (IOException e) {
            log.error("Failure closing file watcher monitor", (Throwable)e);
        }
    }

    public static final class DefaultFileFilter
    implements Filter<Local> {
        private final Local file;

        public DefaultFileFilter(Local file) {
            this.file = file;
        }

        @Override
        public boolean accept(Local f) {
            return StringUtils.equals((CharSequence)this.file.getName(), (CharSequence)f.getName());
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(this.file.getName());
        }
    }
}

