/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.AbstractTemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTemporaryFileService
extends AbstractTemporaryFileService
implements TemporaryFileService {
    private static final Logger log = LogManager.getLogger(DefaultTemporaryFileService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final String delimiter = this.preferences.getProperty("local.delimiter");

    @Override
    public Local create(Path file) {
        return this.create(new UUIDRandomStringService().random(), file);
    }

    @Override
    public Local create(String name) {
        return this.create(LocalFactory.get(this.preferences.getProperty("tmp.dir"), new UUIDRandomStringService().random()), name);
    }

    @Override
    public Local create(String uid, Path file) {
        String pathFormat = "%2$s%1$s%3$s%1$s%4$s";
        String normalizedPathFormat = "%2$s%1$s%3$s%1$s%4$s%1$s%5$s";
        String attributes = "";
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getRegion()) && new DefaultPathContainerService().isContainer(file)) {
            attributes = attributes + file.attributes().getRegion();
        }
        if (file.isFile() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            attributes = attributes + file.attributes().getVersionId();
        }
        int limit = this.preferences.getInteger("local.temporaryfiles.shortening.threshold") - new File(this.preferences.getProperty("tmp.dir"), String.format("%2$s%1$s%3$s%1$s%4$s%1$s%5$s", this.delimiter, uid, "", attributes, file.getName())).getAbsolutePath().length();
        Local folder = LocalFactory.get(this.preferences.getProperty("tmp.dir"), String.format("%2$s%1$s%3$s%1$s%4$s", this.delimiter, uid, this.shorten(file.getParent().getAbsolute(), limit), attributes));
        return this.create(folder, file.getName());
    }

    private Local create(Local folder, String filename) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Creating intermediate folder %s", folder));
            }
            folder.mkdir();
        }
        catch (AccessDeniedException e) {
            log.warn(String.format("Failure %s creating intermediate folder", e));
            return this.delete(LocalFactory.get(this.preferences.getProperty("tmp.dir"), String.format("%s-%s", new AlphanumericRandomStringService().random(), filename)));
        }
        this.delete(folder);
        return this.delete(LocalFactory.get(folder, filename));
    }
}

