/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Directory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultLocalDirectoryFeature
implements Directory {
    private static final Logger log = LogManager.getLogger(DefaultLocalDirectoryFeature.class);

    @Override
    public void mkdir(Local file) throws AccessDeniedException {
        try {
            Files.createDirectories(Paths.get(file.getAbsolute(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(MessageFormat.format(LocaleFactory.localizedString("Cannot create folder {0}", "Error"), file.getName()), e);
        }
    }
}

