/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io.watchservice;

import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOEventWatchService
implements RegisterWatchService {
    private static final Logger log = LogManager.getLogger(NIOEventWatchService.class);
    private WatchService monitor;

    @Override
    public WatchKey register(Watchable folder, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (null == this.monitor) {
            this.monitor = FileSystems.getDefault().newWatchService();
        }
        WatchKey key = folder.register(this.monitor, events, modifiers);
        if (log.isInfoEnabled()) {
            log.info(String.format("Registered for events for %s", key));
        }
        return key;
    }

    @Override
    public void release() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.monitor.close();
    }

    @Override
    public WatchKey poll() {
        return this.monitor.poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.monitor.poll(timeout, unit);
    }

    @Override
    public WatchKey take() throws InterruptedException {
        return this.monitor.take();
    }
}

