/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumCanceledException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.transfer.TransferStatus;
import com.twmacinta.util.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class MD5FastChecksumCompute
extends AbstractChecksumCompute {
    @Override
    public Checksum compute(InputStream in, TransferStatus status) throws BackgroundException {
        return new Checksum(HashAlgorithm.md5, Hex.encodeHexString((byte[])this.digest("MD5", this.normalize(in, status), (StreamCancelation)status)));
    }

    @Override
    protected byte[] digest(String algorithm, InputStream in, StreamCancelation cancelation) throws ChecksumException, ChecksumCanceledException {
        MD5 md = new MD5();
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                md.Update(buffer, 0, bytesRead);
            }
        }
        catch (ClosedChannelException e) {
            throw new ChecksumCanceledException(e);
        }
        catch (IOException e) {
            throw new ChecksumException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return md.Final();
    }

    static {
        MD5.initNativeLibrary((boolean)true);
    }
}

