/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.HashAlgorithm;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Checksum {
    private static final Logger log = LogManager.getLogger(Checksum.class);
    public final HashAlgorithm algorithm;
    public final String hash;
    public static final Checksum NONE = new Checksum(null, null);

    public Checksum(HashAlgorithm algorithm, String hash) {
        this.algorithm = algorithm;
        this.hash = hash;
    }

    public Checksum(Checksum other) {
        this.algorithm = other.algorithm;
        this.hash = other.hash;
    }

    public String toString() {
        return this.hash;
    }

    public static Checksum parse(String hash) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            return NONE;
        }
        switch (hash.length()) {
            case 8: {
                if (!hash.matches("[a-fA-F0-9]{8}")) break;
                return new Checksum(HashAlgorithm.crc32, hash);
            }
            case 32: {
                if (!hash.matches("[a-fA-F0-9]{32}")) break;
                return new Checksum(HashAlgorithm.md5, hash);
            }
            case 40: {
                if (!hash.matches("[a-fA-F0-9]{40}")) break;
                return new Checksum(HashAlgorithm.sha1, hash);
            }
            case 64: {
                if (!hash.matches("[A-Fa-f0-9]{64}")) break;
                return new Checksum(HashAlgorithm.sha256, hash);
            }
            case 128: {
                if (!hash.matches("[A-Fa-f0-9]{128}")) break;
                return new Checksum(HashAlgorithm.sha512, hash);
            }
            default: {
                log.warn(String.format("Failure to detect algorithm for checksum %s", hash));
            }
        }
        return NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        if (this.algorithm != checksum.algorithm) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.hash, (CharSequence)checksum.hash);
    }

    public int hashCode() {
        int result = this.algorithm != null ? this.algorithm.hashCode() : 0;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }
}

