/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;

public class CRC32ChecksumCompute
extends AbstractChecksumCompute {
    @Override
    public Checksum compute(InputStream in, TransferStatus status) throws BackgroundException {
        InputStream normalized = this.normalize(in, status);
        CRC32 crc32 = new CRC32();
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = normalized.read(buffer, 0, buffer.length)) != -1) {
                crc32.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new ChecksumException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)normalized);
        }
        return new Checksum(HashAlgorithm.crc32, Long.toHexString(crc32.getValue()));
    }
}

