/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumCanceledException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

public abstract class AbstractChecksumCompute
implements ChecksumCompute {
    protected byte[] digest(String algorithm, InputStream in, StreamCancelation cancelation) throws ConnectionCanceledException, ChecksumException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(e);
        }
        return this.digest(in, md, cancelation);
    }

    protected byte[] digest(InputStream in, MessageDigest md, StreamCancelation cancelation) throws ConnectionCanceledException, ChecksumException {
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                cancelation.validate();
                md.update(buffer, 0, bytesRead);
            }
        }
        catch (ClosedChannelException e) {
            throw new ChecksumCanceledException(e);
        }
        catch (IOException e) {
            throw new ChecksumException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return md.digest();
    }

    protected InputStream normalize(InputStream in, TransferStatus status) throws ChecksumException {
        try {
            InputStream bounded = status.getLength() > 0L ? new BoundedInputStream(in, status.getOffset() + status.getLength()) : in;
            return status.getOffset() > 0L ? StreamCopier.skip(bounded, status.getOffset()) : bounded;
        }
        catch (BackgroundException e) {
            throw new ChecksumException(e);
        }
    }
}

