/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.idna;

import ch.cyberduck.core.preferences.PreferencesFactory;
import java.net.IDN;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PunycodeConverter {
    private static final Logger log = LogManager.getLogger(PunycodeConverter.class);

    public String convert(String hostname) {
        if (!PreferencesFactory.get().getBoolean("connection.hostname.idn")) {
            return StringUtils.strip((String)hostname);
        }
        if (StringUtils.isNotEmpty((CharSequence)hostname)) {
            try {
                String idn = IDN.toASCII(StringUtils.strip((String)hostname));
                if (log.isDebugEnabled() && !StringUtils.equals((CharSequence)StringUtils.strip((String)hostname), (CharSequence)idn)) {
                    log.debug(String.format("IDN hostname for %s is %s", hostname, idn));
                }
                if (StringUtils.isNotEmpty((CharSequence)idn)) {
                    return idn;
                }
            }
            catch (IllegalArgumentException e) {
                log.warn(String.format("Failed to convert hostname %s to IDNA", hostname), (Throwable)e);
            }
        }
        return StringUtils.strip((String)hostname);
    }
}

