/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.http.HttpRateLimiter;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RateLimitingHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LogManager.getLogger(RateLimitingHttpRequestInterceptor.class);
    private final HttpRateLimiter limiter;

    public RateLimitingHttpRequestInterceptor(HttpRateLimiter limiter) {
        this.limiter = limiter;
    }

    public void process(HttpRequest request, HttpContext context) {
        if (!this.limiter.tryAcquire()) {
            log.warn(String.format("Wait for rate limiting lock from %s", this.limiter));
            double time = this.limiter.acquire();
            if (log.isInfoEnabled()) {
                log.info(String.format("Proceed after waiting %s seconds from %s", time, this.limiter));
            }
        }
    }
}

