/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HttpResponseOutputStream<Reply>
extends StatusOutputStream<Reply> {
    private static final Logger log = LogManager.getLogger(StatusOutputStream.class);
    private final AttributesAdapter<Reply> attributes;
    private final TransferStatus status;

    public HttpResponseOutputStream(OutputStream proxy, AttributesAdapter<Reply> attributes, TransferStatus status) {
        super(proxy);
        this.attributes = attributes;
        this.status = status;
    }

    public void close() throws IOException {
        super.close();
        try {
            Object response = this.getStatus();
            if (response != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Closed stream %s with response value %s", new Object[]{this, response}));
                }
                this.status.withResponse(this.attributes.toAttributes(response)).setComplete();
            }
        }
        catch (BackgroundException e) {
            throw new IOException(e.getDetail(), e);
        }
    }
}

