/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodReleaseInputStream
extends CountingInputStream {
    private static final Logger log = LoggerFactory.getLogger(HttpMethodReleaseInputStream.class);
    private final AtomicBoolean close = new AtomicBoolean();
    private final HttpResponse response;

    public HttpMethodReleaseInputStream(HttpResponse response) throws IOException {
        this(response, new TransferStatus());
    }

    public HttpMethodReleaseInputStream(HttpResponse response, TransferStatus status) throws IOException {
        super((InputStream)(null == response.getEntity() ? new NullInputStream(0L) : response.getEntity().getContent()));
        this.response = response;
        if (null != response.getEntity() && -1L == response.getEntity().getContentLength()) {
            log.warn(String.format("Discard length in transfer status for unknown content length in response %s", response));
            status.setLength(-1L);
        }
    }

    public void close() throws IOException {
        if (this.close.get()) {
            log.warn(String.format("Skip double close of stream %s", new Object[]{this}));
            return;
        }
        try {
            if (this.response instanceof CloseableHttpResponse) {
                if (null == this.response.getEntity()) {
                    super.close();
                } else if (-1L == this.response.getEntity().getContentLength() && -1L == (long)this.read()) {
                    super.close();
                } else if (this.getByteCount() == this.response.getEntity().getContentLength()) {
                    super.close();
                } else {
                    log.warn("Abort connection for response '{}'", (Object)this.response);
                    ((CloseableHttpResponse)this.response).close();
                }
            } else {
                super.close();
            }
        }
        finally {
            this.close.set(true);
        }
    }
}

