/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.ConnectionTimeoutFactory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.ProxyCredentialsStoreFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.http.BackportWindowsNTLMSchemeFactory;
import ch.cyberduck.core.http.BackportWindowsNegotiateSchemeFactory;
import ch.cyberduck.core.http.CallbackProxyAuthenticationStrategy;
import ch.cyberduck.core.http.CustomDnsResolver;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.http.DisabledX509HostnameVerifier;
import ch.cyberduck.core.http.ExtendedHttpRequestRetryHandler;
import ch.cyberduck.core.http.LoggingHttpRequestExecutor;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.WinHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpConnectionPoolBuilder {
    private static final Logger log = LogManager.getLogger(HttpConnectionPoolBuilder.class);
    private final ConnectionSocketFactory socketFactory;
    private final ConnectionSocketFactory sslSocketFactory;
    private final Host host;

    public HttpConnectionPoolBuilder(final Host host, final ThreadLocalHostnameDelegatingTrustManager trust, X509KeyManager key, final ProxyFinder proxy) {
        this(host, (ConnectionSocketFactory)new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) throws IOException {
                return new ProxySocketFactory(host, proxy).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host2, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                trust.setTarget(host2.getHostName());
                return super.connectSocket(connectTimeout, socket, host2, remoteAddress, localAddress, context);
            }
        }, (ConnectionSocketFactory)new SSLConnectionSocketFactory(new CustomTrustSSLProtocolSocketFactory(trust, key), new DisabledX509HostnameVerifier()){

            public Socket createSocket(HttpContext context) throws IOException {
                return new ProxySocketFactory(host, proxy).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }

            public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
                trust.setTarget(target);
                return super.createLayeredSocket(socket, target, port, context);
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host2, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                trust.setTarget(host2.getHostName());
                return super.connectSocket(connectTimeout, socket, host2, remoteAddress, localAddress, context);
            }
        });
    }

    public HttpConnectionPoolBuilder(Host host, ConnectionSocketFactory socketFactory, ConnectionSocketFactory sslSocketFactory) {
        this.host = host;
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
    }

    public HttpClientBuilder build(Proxy proxy, TranscriptListener listener, LoginCallback prompt) {
        HttpClientBuilder configuration = HttpClients.custom();
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                HttpHost h = new HttpHost(proxy.getHostname(), proxy.getPort(), Scheme.http.name());
                if (log.isInfoEnabled()) {
                    log.info(String.format("Setup proxy %s", h));
                }
                configuration.setProxy(h);
                configuration.setProxyAuthenticationStrategy((AuthenticationStrategy)new CallbackProxyAuthenticationStrategy(ProxyCredentialsStoreFactory.get(), this.host, prompt));
            }
        }
        configuration.setUserAgent(new PreferencesUseragentProvider().get());
        int timeout = ConnectionTimeoutFactory.get(this.host).getTimeout() * 1000;
        configuration.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(timeout).build());
        configuration.setDefaultRequestConfig(this.createRequestConfig(timeout));
        configuration.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(new HostPreferences(this.host).getInteger("http.socket.buffer")).setCharset(Charset.forName(this.host.getEncoding())).build());
        if (new HostPreferences(this.host).getBoolean("http.connections.reuse")) {
            configuration.setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultClientConnectionReuseStrategy());
        } else {
            configuration.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        configuration.setRetryHandler((HttpRequestRetryHandler)new ExtendedHttpRequestRetryHandler(new HostPreferences(this.host).getInteger("http.connections.retry")));
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DisabledServiceUnavailableRetryStrategy());
        if (!new HostPreferences(this.host).getBoolean("http.compression.enable")) {
            configuration.disableContentCompression();
        }
        configuration.setRequestExecutor((HttpRequestExecutor)new LoggingHttpRequestExecutor(listener));
        configuration.setConnectionManager((HttpClientConnectionManager)this.createConnectionManager(this.createRegistry()));
        configuration.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(Charset.forName(new HostPreferences(this.host).getProperty("http.credentials.charset")))).register("Digest", (Object)new DigestSchemeFactory(Charset.forName(new HostPreferences(this.host).getProperty("http.credentials.charset")))).register("NTLM", (Object)(new HostPreferences(this.host).getBoolean("webdav.ntlm.windows.authentication.enable") && WinHttpClients.isWinAuthAvailable() ? new BackportWindowsNTLMSchemeFactory(null) : new NTLMSchemeFactory())).register("Negotiate", (Object)(new HostPreferences(this.host).getBoolean("webdav.ntlm.windows.authentication.enable") && WinHttpClients.isWinAuthAvailable() ? new BackportWindowsNegotiateSchemeFactory(null) : new SPNegoSchemeFactory())).register("Kerberos", (Object)new KerberosSchemeFactory()).build());
        configuration.setDnsResolver((DnsResolver)new CustomDnsResolver());
        return configuration;
    }

    public RequestConfig createRequestConfig(int timeout) {
        return RequestConfig.custom().setRedirectsEnabled(true).setExpectContinueEnabled(false).setAuthenticationEnabled(true).setConnectTimeout(timeout).setConnectionRequestTimeout(new HostPreferences(this.host).getInteger("http.manager.timeout")).setSocketTimeout(timeout).setNormalizeUri(new HostPreferences(this.host).getBoolean("http.request.uri.normalize")).build();
    }

    public Registry<ConnectionSocketFactory> createRegistry() {
        return RegistryBuilder.create().register(Scheme.http.toString(), (Object)this.socketFactory).register(Scheme.https.toString(), (Object)this.sslSocketFactory).build();
    }

    public PoolingHttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Setup connection pool with registry %s", registry));
        }
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(new HostPreferences(this.host).getInteger("http.connections.total"));
        manager.setDefaultMaxPerRoute(new HostPreferences(this.host).getInteger("http.connections.route"));
        manager.setValidateAfterInactivity(new HostPreferences(this.host).getInteger("http.connections.stale.check.ms"));
        return manager;
    }
}

