/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.http.HttpWriteFeature;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractHttpWriteFeature<R>
extends AppendWriteFeature<R>
implements HttpWriteFeature<R> {
    private static final Logger log = LogManager.getLogger(AbstractHttpWriteFeature.class);
    private final AttributesAdapter<R> attributes;

    public AbstractHttpWriteFeature(AttributesAdapter<R> attributes) {
        this.attributes = attributes;
    }

    @Override
    public HttpResponseOutputStream<R> write(Path file, TransferStatus status, final DelayedHttpEntityCallable<R> command) throws BackgroundException {
        return this.write(file, status, command, new DelayedHttpEntity(){

            @Override
            public long getContentLength() {
                return command.getContentLength();
            }
        });
    }

    public HttpResponseOutputStream<R> write(Path file, final TransferStatus status, final DelayedHttpEntityCallable<R> command, final DelayedHttpEntity entity) throws BackgroundException {
        final CountDownLatch entry = entity.getEntry();
        final CountDownLatch exit = new CountDownLatch(1);
        if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
            entity.setContentType((Header)new BasicHeader("Content-Type", status.getMime()));
        } else {
            entity.setContentType("application/octet-stream");
        }
        final FutureHttpResponse target = new FutureHttpResponse(){

            @Override
            public void run() {
                try {
                    status.validate();
                    this.response = command.call(entity);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                finally {
                    entry.countDown();
                    exit.countDown();
                }
            }
        };
        NamedThreadFactory factory = new NamedThreadFactory(String.format("http-%s", file.getName()));
        Thread t = factory.newThread(target);
        t.start();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)entry);
        if (null != target.getException()) {
            if (target.getException() instanceof BackgroundException) {
                throw (BackgroundException)target.getException();
            }
            throw new DefaultExceptionMappingService().map(target.getException());
        }
        final OutputStream stream = entity.getStream();
        return new HttpResponseOutputStream<R>(stream, this.attributes, status){

            public void flush() throws IOException {
                stream.flush();
            }

            @Override
            public R getStatus() throws BackgroundException {
                status.validate();
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)exit);
                if (null != target.getException()) {
                    if (target.getException() instanceof BackgroundException) {
                        throw (BackgroundException)target.getException();
                    }
                    throw new DefaultExceptionMappingService().map(target.getException());
                }
                return target.getResponse();
            }
        };
    }

    @Override
    public abstract HttpResponseOutputStream<R> write(Path var1, TransferStatus var2, ConnectionCallback var3) throws BackgroundException;

    private abstract class FutureHttpResponse
    implements Runnable {
        Exception exception;
        R response;

        private FutureHttpResponse() {
        }

        public Exception getException() {
            return this.exception;
        }

        public R getResponse() {
            return this.response;
        }
    }
}

