/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.formatter;

import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.Unit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

public abstract class AbstractSizeFormatter
implements SizeFormatter {
    private final Unit kilo;
    private final Unit mega;
    private final Unit giga;
    private final Unit tera;
    private static final String UNKNOWN = "--";

    public AbstractSizeFormatter(Unit kilo, Unit mega, Unit giga, Unit tera) {
        this.kilo = kilo;
        this.mega = mega;
        this.giga = giga;
        this.tera = tera;
    }

    @Override
    public String format(long size) {
        return this.format(size, false);
    }

    @Override
    public String format(long size, boolean plain) {
        if (size < 0L) {
            return UNKNOWN;
        }
        if (size < this.kilo.multiple()) {
            return String.format("%d B", size);
        }
        StringBuilder formatted = new StringBuilder();
        if (size < this.mega.multiple()) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.kilo.multiple()), 1, RoundingMode.HALF_UP)).append(" ").append(this.kilo.suffix());
        } else if (size < this.giga.multiple()) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.mega.multiple()), 1, RoundingMode.HALF_UP)).append(" ").append(this.mega.suffix());
        } else if (size < this.tera.multiple()) {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.giga.multiple()), 1, RoundingMode.HALF_UP)).append(" ").append(this.giga.suffix());
        } else {
            formatted.append(new BigDecimal(size).divide(new BigDecimal(this.tera.multiple()), 1, RoundingMode.HALF_UP)).append(" ").append(this.tera.suffix());
        }
        if (plain) {
            formatted.append(" (").append(NumberFormat.getInstance().format(size)).append(" bytes)");
        }
        return formatted.toString();
    }
}

