/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Objects;

public interface Write<Reply> {
    public static final Append override = new Append(false);

    public StatusOutputStream<Reply> write(Path var1, TransferStatus var2, ConnectionCallback var3) throws BackgroundException;

    public Append append(Path var1, TransferStatus var2) throws BackgroundException;

    default public boolean random() {
        return false;
    }

    default public boolean timestamp() {
        return false;
    }

    default public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new DisabledChecksumCompute();
    }

    public static final class Append {
        public final boolean append;
        public Long size = 0L;
        public Checksum checksum = Checksum.NONE;

        public Append(boolean append) {
            this.append = append;
        }

        public Append withChecksum(Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        public Append withSize(Long size) {
            this.size = size;
            return this;
        }

        public Append withStatus(TransferStatus status) {
            return this.withSize(-1L == status.getRemote().getSize() ? 0L : status.getRemote().getSize()).withChecksum(status.getRemote().getChecksum());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Append)) {
                return false;
            }
            Append append1 = (Append)o;
            return this.append == append1.append && Objects.equals(this.size, append1.size) && Objects.equals(this.checksum, append1.checksum);
        }

        public int hashCode() {
            return Objects.hash(this.append, this.size, this.checksum);
        }
    }
}

