/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EditorFactory
extends Factory<EditorFactory> {
    private static final Logger log = LogManager.getLogger(EditorFactory.class);
    private static final Preferences preferences = PreferencesFactory.get();
    private static final ApplicationFinder finder = ApplicationFinderFactory.get();

    public static synchronized EditorFactory instance() {
        try {
            String clazz = PreferencesFactory.get().getProperty("factory.editorfactory.class");
            if (null == clazz) {
                throw new FactoryException();
            }
            Class<?> name = Class.forName(clazz);
            return (EditorFactory)name.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    protected abstract List<Application> getConfigured();

    public List<Application> getEditors() {
        ArrayList<Application> editors = new ArrayList<Application>(this.getConfigured());
        Application defaultEditor = EditorFactory.getDefaultEditor();
        if (finder.isInstalled(defaultEditor) && !editors.contains(defaultEditor)) {
            editors.add(defaultEditor);
        }
        return editors;
    }

    public abstract Editor create(Host var1, Path var2, ProgressListener var3);

    public static Application getDefaultEditor() {
        Application application = finder.getDescription(preferences.getProperty("editor.bundleIdentifier"));
        if (finder.isInstalled(application)) {
            return application;
        }
        return Application.notfound;
    }

    public static Application getEditor(String filename) {
        Application application = EditorFactory.getDefaultEditor();
        if (preferences.getBoolean("editor.alwaysUseDefault")) {
            return application;
        }
        Application editor = finder.find(filename);
        if (!finder.isInstalled(editor)) {
            log.warn(String.format("No editor found for %s", filename));
            return application;
        }
        return editor;
    }

    public static List<Application> getEditors(String filename) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Find installed editors for file %s", filename));
        }
        ArrayList<Application> editors = new ArrayList<Application>(finder.findAll(filename));
        Application defaultEditor = EditorFactory.getDefaultEditor();
        if (finder.isInstalled(defaultEditor) && !editors.contains(defaultEditor)) {
            editors.add(defaultEditor);
        }
        return editors;
    }
}

