/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.filter.DownloadDuplicateFilter;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.worker.SingleTransferWorker;
import ch.cyberduck.core.worker.Worker;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditOpenWorker
extends Worker<Transfer> {
    private static final Logger log = LogManager.getLogger(EditOpenWorker.class);
    private final AbstractEditor editor;
    private final Transfer download;
    private final Path file;
    private final Local local;
    private final NotificationService notification;
    private final ProgressListener listener;
    private final FileWatcherListener watcher;
    private final Application application;

    public EditOpenWorker(Host bookmark, AbstractEditor editor, Application application, Path file, Local local, ProgressListener listener, FileWatcherListener watcher, NotificationService notification) {
        this.application = application;
        this.file = file;
        this.editor = editor;
        this.local = local;
        this.notification = notification;
        DownloadFilterOptions options = new DownloadFilterOptions(bookmark);
        options.quarantine = false;
        options.wherefrom = false;
        options.open = false;
        this.download = new DownloadTransfer(bookmark, file, local, new DownloadDuplicateFilter()){

            @Override
            public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) {
                return TransferAction.trash;
            }
        }.withOptions(options);
        this.listener = listener;
        this.watcher = watcher;
    }

    @Override
    public Transfer run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run edit action for editor %s", this.file));
        }
        TransferOptions options = new TransferOptions();
        SingleTransferWorker worker = new SingleTransferWorker(session, session, this.download, options, new TransferSpeedometer(this.download), new DisabledTransferPrompt(), new DisabledTransferErrorCallback(), this.listener, new DisabledStreamListener(), new DisabledLoginCallback(), this.notification);
        worker.run((Session)session);
        if (!this.download.isComplete()) {
            log.warn(String.format("File size changed for %s", this.file));
        }
        try {
            this.editor.edit(this.application, this.file, this.local, this.watcher);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        return this.download;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Downloading {0}", "Status"), this.file.getName());
    }

    @Override
    public Transfer initialize() {
        return this.download;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditOpenWorker that = (EditOpenWorker)o;
        return Objects.equals(this.editor, that.editor);
    }

    public int hashCode() {
        return this.editor != null ? this.editor.hashCode() : 0;
    }
}

