/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.AbstractEditor;
import ch.cyberduck.core.io.watchservice.NIOEventWatchService;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.local.FileWatcherListener;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultWatchEditor
extends AbstractEditor {
    private static final Logger log = LogManager.getLogger(DefaultWatchEditor.class);
    private final FileWatcher monitor;

    public DefaultWatchEditor(Host host, Path file, ProgressListener listener) {
        this(host, file, listener, new FileWatcher(new NIOEventWatchService()));
    }

    public DefaultWatchEditor(Host host, Path file, ProgressListener listener, FileWatcher monitor) {
        super(host, file, listener);
        this.monitor = monitor;
    }

    @Override
    protected void watch(Application application, Local temporary, FileWatcherListener listener, ApplicationQuitCallback quit) throws IOException {
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.monitor.register(temporary.getParent(), new FileWatcher.DefaultFileFilter(temporary), listener));
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Close monitor %s", this.monitor));
        }
        this.monitor.close();
    }
}

