/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.EditOpenWorker;
import ch.cyberduck.core.editor.EditSaveWorker;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractEditor
implements Editor {
    private static final Logger log = LogManager.getLogger(AbstractEditor.class);
    private final Host host;
    private final TemporaryFileService temp = TemporaryFileServiceFactory.instance();
    private boolean modified;
    private final Path file;
    private final Local temporary;
    private Checksum checksum;
    private final ProgressListener progress;
    private final ApplicationLauncher launcher;
    private final ApplicationFinder finder;
    private final NotificationService notification = NotificationServiceFactory.get();

    public AbstractEditor(Host host, Path file, ProgressListener listener) {
        this(host, file, ApplicationLauncherFactory.get(), ApplicationFinderFactory.get(), listener);
    }

    public AbstractEditor(Host host, Path file, ApplicationLauncher launcher, ApplicationFinder finder, ProgressListener listener) {
        this.host = host;
        this.file = file.isSymbolicLink() && PreferencesFactory.get().getBoolean("editor.upload.symboliclink.resolve") ? file.getSymlinkTarget() : file;
        this.temporary = this.temp.create(host.getUuid(), this.file);
        this.launcher = launcher;
        this.finder = finder;
        this.progress = listener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void delete() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Delete edited file %s", this.temporary));
        }
        try {
            this.temporary.delete();
        }
        catch (AccessDeniedException | NotfoundException e) {
            log.warn(String.format("Failure trashing edited file %s. %s", this.temporary, e.getMessage()));
        }
    }

    @Override
    public Worker<Transfer> open(Application application, ApplicationQuitCallback callback, FileWatcherListener listener) {
        final Local temporary = this.temp.create(this.host.getUuid(), this.file);
        EditOpenWorker worker = new EditOpenWorker(this.host, this, application, this.file, temporary, this.progress, listener, this.notification){

            @Override
            public void cleanup(Transfer download) {
                try {
                    AbstractEditor.this.checksum = ChecksumComputeFactory.get(HashAlgorithm.md5).compute(temporary.getInputStream(), new TransferStatus());
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Error computing checksum for %s. %s", temporary, e));
                }
            }
        };
        if (log.isDebugEnabled()) {
            log.debug(String.format("Download file for edit %s", temporary));
        }
        return worker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void edit(Application application, Path file, Local temporary, FileWatcherListener listener) throws IOException {
        ApplicationQuitCallback quit = new ApplicationQuitCallback(){

            @Override
            public void callback() {
                AbstractEditor.this.close();
                AbstractEditor.this.delete();
            }
        };
        if (!this.finder.isInstalled(application)) {
            log.warn(String.format("No editor application configured for %s", temporary));
            if (!this.launcher.open(temporary)) throw new IOException(String.format("Failed to open default application for %s", temporary.getName()));
            this.watch(application, temporary, listener, quit);
            return;
        } else {
            if (!this.launcher.open(temporary, application)) throw new IOException(String.format("Failed to open application %s for %s", application.getName(), temporary.getName()));
            this.watch(application, temporary, listener, quit);
        }
    }

    protected abstract void watch(Application var1, Local var2, FileWatcherListener var3, ApplicationQuitCallback var4) throws IOException;

    @Override
    public Worker<Transfer> save(TransferErrorCallback error) {
        Checksum current;
        try {
            this.progress.message(MessageFormat.format(LocaleFactory.localizedString("Compute MD5 hash of {0}", "Status"), this.temporary.getName()));
            current = ChecksumComputeFactory.get(HashAlgorithm.md5).compute(this.temporary.getInputStream(), new TransferStatus());
        }
        catch (BackgroundException e) {
            log.warn(String.format("Error computing checksum for %s. %s", this.temporary, e));
            return Worker.empty();
        }
        if (current.equals(this.checksum)) {
            if (log.isInfoEnabled()) {
                log.info(String.format("File %s not modified with checksum %s", this.temporary, current));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info(String.format("Save new checksum %s for file %s", current, this.temporary));
            }
            this.checksum = current;
            EditSaveWorker worker = new EditSaveWorker(this.host, this, this.file, this.temporary, error, this.progress, this.notification);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Upload changes for %s", this.temporary));
            }
            return worker;
        }
        return Worker.empty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractEditor{");
        sb.append("modified=").append(this.modified);
        sb.append(", checksum=").append(this.checksum);
        sb.append('}');
        return sb.toString();
    }
}

