/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DropboxContentHasher
extends MessageDigest
implements Cloneable {
    private MessageDigest overallHasher;
    private MessageDigest blockHasher;
    private int blockPos = 0;
    public static final int BLOCK_SIZE = 0x400000;

    public DropboxContentHasher() {
        this(DropboxContentHasher.newSha256Hasher(), DropboxContentHasher.newSha256Hasher(), 0);
    }

    public DropboxContentHasher(MessageDigest overallHasher, MessageDigest blockHasher, int blockPos) {
        super("Dropbox-Content-Hash");
        this.overallHasher = overallHasher;
        this.blockHasher = blockHasher;
        this.blockPos = blockPos;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.finishBlockIfFull();
        this.blockHasher.update(input);
        ++this.blockPos;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.overallHasher.getDigestLength();
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        int inputEnd = offset + len;
        while (offset < inputEnd) {
            this.finishBlockIfFull();
            int spaceInBlock = 0x400000 - this.blockPos;
            int inputPartEnd = Math.min(inputEnd, offset + spaceInBlock);
            int inputPartLength = inputPartEnd - offset;
            this.blockHasher.update(input, offset, inputPartLength);
            this.blockPos += inputPartLength;
            offset += inputPartLength;
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        int inputEnd = input.limit();
        while (input.position() < inputEnd) {
            this.finishBlockIfFull();
            int spaceInBlock = 0x400000 - this.blockPos;
            int inputPartEnd = Math.min(inputEnd, input.position() + spaceInBlock);
            int inputPartLength = inputPartEnd - input.position();
            input.limit(inputPartEnd);
            this.blockHasher.update(input);
            this.blockPos += inputPartLength;
            input.position(inputPartEnd);
        }
    }

    @Override
    protected byte[] engineDigest() {
        this.finishBlockIfNonEmpty();
        return this.overallHasher.digest();
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        this.finishBlockIfNonEmpty();
        return this.overallHasher.digest(buf, offset, len);
    }

    @Override
    protected void engineReset() {
        this.overallHasher.reset();
        this.blockHasher.reset();
        this.blockPos = 0;
    }

    @Override
    public DropboxContentHasher clone() throws CloneNotSupportedException {
        DropboxContentHasher clone = (DropboxContentHasher)super.clone();
        clone.overallHasher = (MessageDigest)clone.overallHasher.clone();
        clone.blockHasher = (MessageDigest)clone.blockHasher.clone();
        return clone;
    }

    private void finishBlock() {
        this.overallHasher.update(this.blockHasher.digest());
        this.blockPos = 0;
    }

    private void finishBlockIfFull() {
        if (this.blockPos == 0x400000) {
            this.finishBlock();
        }
    }

    private void finishBlockIfNonEmpty() {
        if (this.blockPos > 0) {
            this.finishBlock();
        }
    }

    static MessageDigest newSha256Hasher() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)"Couldn't create SHA-256 hasher");
        }
    }
}

