/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.dropbox.DropboxContentHasher;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class DropboxChecksumCompute
extends AbstractChecksumCompute {
    @Override
    public Checksum compute(InputStream in, TransferStatus status) throws BackgroundException {
        try {
            return new Checksum(HashAlgorithm.dropbox_content_hash, Hex.encodeHexString((byte[])this.digest(this.normalize(in, status), new DropboxContentHasher(MessageDigest.getInstance("SHA-256"), MessageDigest.getInstance("SHA-256"), 0), (StreamCancelation)status)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException(e);
        }
    }
}

