/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.date.DateFormatter;
import ch.cyberduck.core.date.InvalidDateException;
import com.google.gson.internal.bind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;

public class RFC3339DateFormatter
implements DateFormatter {
    @Override
    public String format(Date input, TimeZone zone) {
        return ISO8601Utils.format((Date)input, (boolean)true, (TimeZone)zone);
    }

    @Override
    public String format(long milliseconds, TimeZone zone) {
        return ISO8601Utils.format((Date)Date.from(Instant.ofEpochMilli(milliseconds)), (boolean)true, (TimeZone)zone);
    }

    @Override
    public Date parse(String input) throws InvalidDateException {
        try {
            return ISO8601Utils.parse((String)input, (ParsePosition)new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new InvalidDateException(e.getMessage(), e);
        }
    }
}

