/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cdn;

import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Scheme;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Distribution {
    private String id;
    private String etag;
    private String reference;
    private boolean deployed;
    private final String name;
    private final URI origin;
    private boolean enabled;
    private boolean logging;
    private String loggingContainer;
    private List<Path> containers = Collections.emptyList();
    private URI url;
    private URI sslUrl;
    private URI streamingUrl;
    private URI iOSstreamingUrl;
    private String status;
    private String[] cnames;
    private Method method;
    private String indexDocument;
    private List<Path> rootDocuments = Collections.emptyList();
    private String errorDocument;
    private String invalidationStatus;
    public static final Method WEBSITE = new Method(){

        @Override
        public String toString() {
            return LocaleFactory.localizedString("Website Configuration (HTTP)", "S3");
        }

        @Override
        public Scheme getScheme() {
            return Scheme.http;
        }

        @Override
        public String getContext() {
            return "";
        }
    };
    public static final Method WEBSITE_CDN = new Method(){

        @Override
        public String toString() {
            return LocaleFactory.localizedString("Website Configuration (HTTP) CDN", "S3");
        }

        @Override
        public Scheme getScheme() {
            return Scheme.http;
        }

        @Override
        public String getContext() {
            return "";
        }
    };
    public static final Method DOWNLOAD = new Method(){

        @Override
        public String toString() {
            return LocaleFactory.localizedString("Download (HTTP) CDN", "S3");
        }

        @Override
        public Scheme getScheme() {
            return Scheme.http;
        }

        @Override
        public String getContext() {
            return "";
        }
    };
    public static final Method CUSTOM = new Method(){

        @Override
        public String toString() {
            return LocaleFactory.localizedString("Custom Origin Server (HTTP/HTTPS) CDN", "S3");
        }

        @Override
        public Scheme getScheme() {
            return Scheme.http;
        }

        @Override
        public String getContext() {
            return "";
        }
    };
    public static final Method STREAMING = new Method(){

        @Override
        public String toString() {
            return LocaleFactory.localizedString("Streaming (RTMP) CDN", "S3");
        }

        @Override
        public Scheme getScheme() {
            return Scheme.rtmp;
        }

        @Override
        public String getContext() {
            return "/cfx/st";
        }
    };

    public Distribution(Method method, boolean enabled) {
        this(method, null, enabled);
    }

    public Distribution(Method method, URI origin, boolean enabled) {
        this(method, method.toString(), origin, enabled);
    }

    public Distribution(Method method, String name, URI origin, boolean enabled) {
        this.name = name;
        this.origin = origin;
        this.enabled = enabled;
        this.deployed = enabled;
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getReference() {
        return this.reference;
    }

    public URI getOrigin() {
        return this.origin;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public void setLoggingContainer(String container) {
        this.loggingContainer = container;
    }

    public String getLoggingContainer() {
        return this.loggingContainer;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setSslUrl(URI sslUrl) {
        this.sslUrl = sslUrl;
    }

    public URI getSslUrl() {
        return this.sslUrl;
    }

    public void setStreamingUrl(URI streamingUrl) {
        this.streamingUrl = streamingUrl;
    }

    public URI getStreamingUrl() {
        return this.streamingUrl;
    }

    public URI getiOSstreamingUrl() {
        return this.iOSstreamingUrl;
    }

    public void setiOSstreamingUrl(URI iOSstreamingUrl) {
        this.iOSstreamingUrl = iOSstreamingUrl;
    }

    public String getStatus() {
        if (null == this.status) {
            return LocaleFactory.localizedString("Unknown");
        }
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getInvalidationStatus() {
        if (null == this.invalidationStatus) {
            return LocaleFactory.localizedString("None");
        }
        return this.invalidationStatus;
    }

    public void setInvalidationStatus(String invalidationStatus) {
        this.invalidationStatus = invalidationStatus;
    }

    public List<Path> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Path> containers) {
        this.containers = containers;
    }

    public String getIndexDocument() {
        return this.indexDocument;
    }

    public void setIndexDocument(String indexDocument) {
        this.indexDocument = indexDocument;
    }

    public String getErrorDocument() {
        return this.errorDocument;
    }

    public void setErrorDocument(String errorDocument) {
        this.errorDocument = errorDocument;
    }

    public List<Path> getRootDocuments() {
        return this.rootDocuments;
    }

    public void setRootDocuments(List<Path> rootDocuments) {
        this.rootDocuments = rootDocuments;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String[] getCNAMEs() {
        if (null == this.cnames) {
            return new String[0];
        }
        return this.cnames;
    }

    public void setCNAMEs(String[] cnames) {
        this.cnames = cnames;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Distribution{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", reference='").append(this.reference).append('\'');
        sb.append(", origin=").append(this.origin);
        sb.append(", enabled=").append(this.enabled);
        sb.append(", logging=").append(this.logging);
        sb.append(", url=").append(this.url);
        sb.append(", status='").append(this.status).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Distribution)) {
            return false;
        }
        Distribution that = (Distribution)o;
        return Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public static abstract class Method {
        public abstract String toString();

        public abstract Scheme getScheme();

        public int getDefaultPort() {
            return this.getScheme().getPort();
        }

        public abstract String getContext();

        public static Method forName(String name) {
            if (DOWNLOAD.toString().equals(name)) {
                return DOWNLOAD;
            }
            if (STREAMING.toString().equals(name)) {
                return STREAMING;
            }
            if (CUSTOM.toString().equals(name)) {
                return CUSTOM;
            }
            if (WEBSITE.toString().equals(name)) {
                return WEBSITE;
            }
            if (WEBSITE_CDN.toString().equals(name)) {
                return WEBSITE_CDN;
            }
            throw new FactoryException(name);
        }
    }
}

